/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong.client;

import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.concurrent.atomiclong.AtomicLongPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;

public abstract class AtomicLongRequest
extends PartitionClientRequest
implements Portable {
    String name;
    long delta;

    protected AtomicLongRequest() {
    }

    protected AtomicLongRequest(String name, long delta) {
        this.name = name;
        this.delta = delta;
    }

    @Override
    protected int getPartition() {
        Data key = this.getClientEngine().getSerializationService().toData(this.name);
        return this.getClientEngine().getPartitionService().getPartitionId(key);
    }

    @Override
    protected int getReplicaIndex() {
        return 0;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    @Override
    public int getFactoryId() {
        return AtomicLongPortableHook.F_ID;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("d", this.delta);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.delta = reader.readLong("d");
    }
}

