/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public class InvalidateNearCacheOperation
extends AbstractOperation {
    MapService mapService;
    Data key;
    String mapName;

    public InvalidateNearCacheOperation(String mapName, Data key) {
        this.key = key;
        this.mapName = mapName;
    }

    public InvalidateNearCacheOperation() {
    }

    @Override
    public void run() {
        this.mapService = (MapService)this.getService();
        this.mapService.invalidateNearCache(this.mapName, this.key);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        this.key = (Data)in.readObject();
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        out.writeObject(this.key);
    }

    public String toString() {
        return "InvalidateNearCacheOperation{}";
    }
}

