/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.example;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.gssapi.example.GetOpts;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class Client
extends Thread {
    GetOpts opts;
    Socket s;

    public Client(Socket s, GetOpts opts) {
        this.s = s;
        this.opts = opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("client connected");
        GlobusGSSManagerImpl manager = new GlobusGSSManagerImpl();
        ExtendedGSSContext context = null;
        try {
            OutputStream out = this.s.getOutputStream();
            InputStream in = this.s.getInputStream();
            byte[] inToken = null;
            byte[] outToken = null;
            context = (ExtendedGSSContext)((GSSManager)((Object)manager)).createContext((GSSCredential)null);
            context.requestConf(this.opts.conf);
            context.setOption(GSSConstants.GSS_MODE, (Object)(this.opts.gsiMode ? GSIConstants.MODE_GSI : GSIConstants.MODE_SSL));
            context.setOption(GSSConstants.REJECT_LIMITED_PROXY, (Object)new Boolean(this.opts.rejectLimitedProxy));
            context.setOption(GSSConstants.REQUIRE_CLIENT_AUTH, (Object)new Boolean(!this.opts.anonymity));
            while (!context.isEstablished()) {
                inToken = SSLUtil.readSslMessage(in);
                outToken = context.acceptSecContext(inToken, 0, inToken.length);
                if (outToken == null) continue;
                out.write(outToken);
                out.flush();
            }
            System.out.println("Context established.");
            System.out.println("Initiator : " + context.getSrcName());
            System.out.println("Acceptor  : " + context.getTargName());
            System.out.println("Lifetime  : " + context.getLifetime());
            System.out.println("Privacy   : " + context.getConfState());
            GlobusGSSCredentialImpl cred = (GlobusGSSCredentialImpl)((Object)context.getDelegCred());
            System.out.println("Delegated credential :");
            if (cred != null) {
                System.out.println(cred.getX509Credential());
            } else {
                System.out.println("None");
            }
            inToken = SSLUtil.readSslMessage(in);
            outToken = context.unwrap(inToken, 0, inToken.length, null);
            System.out.println(new String(outToken));
            byte[] msg = "HTTP/1.1 404 Not Found\r\nConnection: close\r\n\r\n".getBytes();
            outToken = context.wrap(msg, 0, msg.length, null);
            out.write(outToken);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.s.close();
            }
            catch (Exception e) {}
            try {
                context.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("client disconnected");
        }
    }
}

