/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VaultNotificationConfig
implements Serializable {
    private String sNSTopic;
    private ListWithAutoConstructFlag<String> events;

    public VaultNotificationConfig() {
    }

    public VaultNotificationConfig(String sNSTopic, List<String> events) {
        this.setSNSTopic(sNSTopic);
        this.setEvents(events);
    }

    public String getSNSTopic() {
        return this.sNSTopic;
    }

    public void setSNSTopic(String sNSTopic) {
        this.sNSTopic = sNSTopic;
    }

    public VaultNotificationConfig withSNSTopic(String sNSTopic) {
        this.sNSTopic = sNSTopic;
        return this;
    }

    public List<String> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<String> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public VaultNotificationConfig withEvents(String ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<String>(events.length));
        }
        for (String value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public VaultNotificationConfig withEvents(Collection<String> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSNSTopic() != null) {
            sb.append("SNSTopic: " + this.getSNSTopic() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSNSTopic() == null ? 0 : this.getSNSTopic().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaultNotificationConfig)) {
            return false;
        }
        VaultNotificationConfig other = (VaultNotificationConfig)obj;
        if (other.getSNSTopic() == null ^ this.getSNSTopic() == null) {
            return false;
        }
        if (other.getSNSTopic() != null && !other.getSNSTopic().equals(this.getSNSTopic())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }
}

