/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.AppInput_PK;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationIntInput;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationInterface;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInputResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInputResource.class);
    private String interfaceID;
    private String inputKey;
    private String dataType;
    private String inputVal;
    private String metadata;
    private String appArgument;
    private String userFriendlyDesc;
    private int inputOrder;
    private boolean standardInput;
    private boolean isRequired;
    private boolean requiredToCMD;
    private boolean dataStaged;
    private boolean isReadOnly;
    private AppInterfaceResource appInterfaceResource;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntInput", new Object[0][]);
            generator.setParameter("interfaceID", ids.get("interfaceID"));
            if (ids.get("inputKey") != null) {
                generator.setParameter("inputKey", ids.get("inputKey"));
            }
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntInput", new Object[0][]);
            generator.setParameter("interfaceID", ids.get("interfaceID"));
            generator.setParameter("inputKey", ids.get("inputKey"));
            Query q = generator.selectQuery(em);
            ApplicationIntInput applicationInput = (ApplicationIntInput)q.getSingleResult();
            ApplicationInputResource applicationInputResource = (ApplicationInputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_INPUT, applicationInput);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ApplicationInputResource applicationInputResource2 = applicationInputResource;
            return applicationInputResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> appInputResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntInput", new Object[0][]);
            if (fieldName.equals("interfaceID")) {
                generator.setParameter("interfaceID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntInput applicationInput = (ApplicationIntInput)result;
                        ApplicationInputResource applicationInputResource = (ApplicationInputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_INPUT, applicationInput);
                        appInputResources.add(applicationInputResource);
                    }
                }
            } else if (fieldName.equals("inputKey")) {
                generator.setParameter("inputKey", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntInput applicationInput = (ApplicationIntInput)result;
                        ApplicationInputResource applicationInputResource = (ApplicationInputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_INPUT, applicationInput);
                        appInputResources.add(applicationInputResource);
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntInput applicationInput = (ApplicationIntInput)result;
                        ApplicationInputResource applicationInputResource = (ApplicationInputResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_INPUT, applicationInput);
                        appInputResources.add(applicationInputResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for AppInput Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for AppInput Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appInputResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> appInputResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationIntInput", new Object[0][]);
            if (fieldName.equals("interfaceID")) {
                generator.setParameter("interfaceID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntInput applicationInput = (ApplicationIntInput)result;
                        appInputResourceIDs.add(applicationInput.getInterfaceID());
                    }
                }
            } else if (fieldName.equals("inputKey")) {
                generator.setParameter("inputKey", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntInput applicationInput = (ApplicationIntInput)result;
                        appInputResourceIDs.add(applicationInput.getInterfaceID());
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationIntInput applicationInput = (ApplicationIntInput)result;
                        appInputResourceIDs.add(applicationInput.getInterfaceID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for AppInput resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for AppInput Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appInputResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ApplicationIntInput existingApplicationInput = (ApplicationIntInput)em.find(ApplicationIntInput.class, (Object)new AppInput_PK(this.interfaceID, this.inputKey));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ApplicationIntInput applicationInput = existingApplicationInput == null ? new ApplicationIntInput() : existingApplicationInput;
            ApplicationInterface applicationInterface = (ApplicationInterface)em.find(ApplicationInterface.class, (Object)this.interfaceID);
            applicationInput.setApplicationInterface(applicationInterface);
            applicationInput.setInterfaceID(applicationInterface.getInterfaceID());
            applicationInput.setDataType(this.dataType);
            applicationInput.setInputKey(this.inputKey);
            applicationInput.setInputVal(this.inputVal);
            applicationInput.setMetadata(this.metadata);
            applicationInput.setAppArgument(this.appArgument);
            applicationInput.setUserFriendlyDesc(this.userFriendlyDesc);
            applicationInput.setStandardInput(this.standardInput);
            applicationInput.setInputOrder(this.inputOrder);
            applicationInput.setRequiredToCMD(this.requiredToCMD);
            applicationInput.setRequired(this.isRequired);
            applicationInput.setDataStaged(this.dataStaged);
            applicationInput.setReadOnly(this.isReadOnly);
            if (existingApplicationInput == null) {
                em.persist((Object)applicationInput);
            } else {
                em.merge((Object)applicationInput);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ApplicationIntInput applicationInput = (ApplicationIntInput)em.find(ApplicationIntInput.class, (Object)new AppInput_PK((String)ids.get("interfaceID"), (String)ids.get("inputKey")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = applicationInput != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getInterfaceID() {
        return this.interfaceID;
    }

    public void setInterfaceID(String interfaceID) {
        this.interfaceID = interfaceID;
    }

    public String getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getInputVal() {
        return this.inputVal;
    }

    public void setInputVal(String inputVal) {
        this.inputVal = inputVal;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getAppArgument() {
        return this.appArgument;
    }

    public void setAppArgument(String appArgument) {
        this.appArgument = appArgument;
    }

    public String getUserFriendlyDesc() {
        return this.userFriendlyDesc;
    }

    public void setUserFriendlyDesc(String userFriendlyDesc) {
        this.userFriendlyDesc = userFriendlyDesc;
    }

    public AppInterfaceResource getAppInterfaceResource() {
        return this.appInterfaceResource;
    }

    public void setAppInterfaceResource(AppInterfaceResource appInterfaceResource) {
        this.appInterfaceResource = appInterfaceResource;
    }

    public boolean isStandardInput() {
        return this.standardInput;
    }

    public void setStandardInput(boolean standardInput) {
        this.standardInput = standardInput;
    }

    public int getInputOrder() {
        return this.inputOrder;
    }

    public void setInputOrder(int inputOrder) {
        this.inputOrder = inputOrder;
    }

    public boolean getRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean getRequiredToCMD() {
        return this.requiredToCMD;
    }

    public void setRequiredToCMD(boolean requiredToCMD) {
        this.requiredToCMD = requiredToCMD;
    }

    public boolean isDataStaged() {
        return this.dataStaged;
    }

    public void setDataStaged(boolean dataStaged) {
        this.dataStaged = dataStaged;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }
}

