/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentOutput;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentOutputPK;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentOutputResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentOutputResource.class);
    private String experimentId;
    private String outputName;
    private String outputValue;
    private String dataType;
    private String applicationArgument;
    private boolean isRequired;
    private boolean requiredToAddedToCmd;
    private boolean dataMovement;
    private String location;
    private String searchQuery;
    private boolean outputStreaming;
    private String storageResourceId;

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getOutputValue() {
        return this.outputValue;
    }

    public void setOutputValue(String outputValue) {
        this.outputValue = outputValue;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getApplicationArgument() {
        return this.applicationArgument;
    }

    public void setApplicationArgument(String applicationArgument) {
        this.applicationArgument = applicationArgument;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean getRequiredToAddedToCmd() {
        return this.requiredToAddedToCmd;
    }

    public void setRequiredToAddedToCmd(boolean requiredToAddedToCmd) {
        this.requiredToAddedToCmd = requiredToAddedToCmd;
    }

    public boolean getDataMovement() {
        return this.dataMovement;
    }

    public void setDataMovement(boolean dataMovement) {
        this.dataMovement = dataMovement;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public void setOutputStreaming(boolean outputStreaming) {
        this.outputStreaming = outputStreaming;
    }

    public boolean isOutputStreaming() {
        return this.outputStreaming;
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            if (this.experimentId == null) {
                throw new RegistryException("Does not have the experiment id");
            }
            ExperimentOutputPK experimentOutputPK = new ExperimentOutputPK();
            experimentOutputPK.setExperimentId(this.experimentId);
            experimentOutputPK.setOutputName(this.outputName);
            ExperimentOutput existingExpOutput = (ExperimentOutput)em.find(ExperimentOutput.class, (Object)experimentOutputPK);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ExperimentOutput experimentOutput = existingExpOutput == null ? new ExperimentOutput() : existingExpOutput;
            experimentOutput.setExperimentId(this.experimentId);
            experimentOutput.setOutputName(this.outputName);
            experimentOutput.setOutputValue(this.outputValue);
            experimentOutput.setDataType(this.dataType);
            experimentOutput.setApplicationArgument(this.applicationArgument);
            experimentOutput.setIsRequired(this.isRequired);
            experimentOutput.setRequiredToAddedToCmd(this.requiredToAddedToCmd);
            experimentOutput.setDataMovement(this.dataMovement);
            experimentOutput.setLocation(this.location);
            experimentOutput.setSearchQuery(this.searchQuery);
            experimentOutput.setOutputStreaming(this.outputStreaming);
            experimentOutput.setStorageResourceId(this.storageResourceId);
            if (existingExpOutput == null) {
                em.persist((Object)experimentOutput);
            } else {
                em.merge((Object)experimentOutput);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

