/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.store.impl;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.common.utils.DefaultKeyStorePasswordCallback;
import org.apache.airavata.common.utils.KeyStorePasswordCallback;
import org.apache.airavata.credential.store.credential.CommunityUser;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.store.CredentialWriter;
import org.apache.airavata.credential.store.store.impl.db.CommunityUserDAO;
import org.apache.airavata.credential.store.store.impl.db.CredentialsDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateCredentialWriter
implements CredentialWriter {
    private CredentialsDAO credentialsDAO;
    private CommunityUserDAO communityUserDAO;
    protected static Logger log = LoggerFactory.getLogger(CertificateCredentialWriter.class);
    private DBUtil dbUtil;

    public CertificateCredentialWriter(DBUtil dbUtil) throws ApplicationSettingsException {
        this.dbUtil = dbUtil;
        this.credentialsDAO = new CredentialsDAO(ApplicationSettings.getCredentialStoreKeyStorePath(), ApplicationSettings.getCredentialStoreKeyAlias(), (KeyStorePasswordCallback)new DefaultKeyStorePasswordCallback());
        this.communityUserDAO = new CommunityUserDAO();
    }

    @Override
    public void writeCredentials(Credential credential) throws CredentialStoreException {
        CertificateCredential certificateCredential = (CertificateCredential)credential;
        Connection connection = null;
        try {
            connection = this.dbUtil.getConnection();
            this.writeCommunityUser(certificateCredential.getCommunityUser(), credential.getToken(), connection);
            this.credentialsDAO.deleteCredentials(certificateCredential.getCommunityUser().getGatewayName(), certificateCredential.getToken(), connection);
            this.credentialsDAO.addCredentials(certificateCredential.getCommunityUser().getGatewayName(), credential, connection);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    log.error("Unable to rollback transaction", (Throwable)e1);
                }
            }
            throw new CredentialStoreException("Unable to retrieve database connection.", e);
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
    }

    public void writeCommunityUser(CommunityUser communityUser, String token, Connection connection) throws CredentialStoreException {
        this.communityUserDAO.deleteCommunityUserByToken(communityUser, token, connection);
        this.communityUserDAO.addCommunityUser(communityUser, token, connection);
    }
}

