/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.store.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.common.utils.DefaultKeyStorePasswordCallback;
import org.apache.airavata.common.utils.KeyStorePasswordCallback;
import org.apache.airavata.credential.store.credential.CommunityUser;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateAuditInfo;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.store.impl.db.CredentialsDAO;

public class CredentialReaderImpl
implements CredentialReader,
Serializable {
    private CredentialsDAO credentialsDAO = new CredentialsDAO(ApplicationSettings.getCredentialStoreKeyStorePath(), ApplicationSettings.getCredentialStoreKeyAlias(), (KeyStorePasswordCallback)new DefaultKeyStorePasswordCallback());
    private DBUtil dbUtil;

    public CredentialReaderImpl(DBUtil dbUtil) throws ApplicationSettingsException {
        this.dbUtil = dbUtil;
    }

    private Connection getConnection() throws CredentialStoreException {
        try {
            return this.dbUtil.getConnection();
        }
        catch (SQLException e) {
            throw new CredentialStoreException("Unable to retrieve database connection.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential getCredential(String gatewayId, String tokenId) throws CredentialStoreException {
        Connection connection = this.getConnection();
        try {
            Credential credential = this.credentialsDAO.getCredential(gatewayId, tokenId, connection);
            return credential;
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
    }

    @Override
    public List<Credential> getAllCredentials() throws CredentialStoreException {
        Connection connection = this.getConnection();
        try {
            List<Credential> list = this.credentialsDAO.getCredentials(connection);
            return list;
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Credential> getAllCredentialsPerGateway(String gatewayId) throws CredentialStoreException {
        Connection connection = this.getConnection();
        try {
            List<Credential> list = this.credentialsDAO.getCredentials(gatewayId, connection);
            return list;
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
    }

    @Override
    public List<Credential> getAllCredentialsPerUser(String userName) throws CredentialStoreException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPortalUser(String gatewayName, String tokenId) throws CredentialStoreException {
        Credential credential;
        Connection connection = this.getConnection();
        try {
            credential = this.credentialsDAO.getCredential(gatewayName, tokenId, connection);
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
        return credential.getPortalUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateAuditInfo getAuditInfo(String gatewayName, String tokenId) throws CredentialStoreException {
        CertificateAuditInfo certificateAuditInfo;
        Connection connection = this.getConnection();
        try {
            CertificateCredential certificateCredential = (CertificateCredential)this.credentialsDAO.getCredential(gatewayName, tokenId, connection);
            certificateAuditInfo = new CertificateAuditInfo();
            CommunityUser retrievedUser = certificateCredential.getCommunityUser();
            certificateAuditInfo.setCommunityUserName(retrievedUser.getUserName());
            certificateAuditInfo.setCredentialLifeTime(certificateCredential.getLifeTime());
            certificateAuditInfo.setCredentialsRequestedTime(certificateCredential.getCertificateRequestedTime());
            certificateAuditInfo.setGatewayName(gatewayName);
            certificateAuditInfo.setNotAfter(certificateCredential.getNotAfter());
            certificateAuditInfo.setNotBefore(certificateCredential.getNotBefore());
            certificateAuditInfo.setPortalUserName(certificateCredential.getPortalUserName());
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
        return certificateAuditInfo;
    }

    @Override
    public void updateCommunityUserEmail(String gatewayName, String communityUser, String email) throws CredentialStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCredentials(String gatewayName, String tokenId) throws CredentialStoreException {
        Connection connection = this.getConnection();
        try {
            this.credentialsDAO.deleteCredentials(gatewayName, tokenId, connection);
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGatewayID(String tokenId) throws CredentialStoreException {
        Connection connection = this.getConnection();
        try {
            String string = this.credentialsDAO.getGatewayID(tokenId, connection);
            return string;
        }
        finally {
            DBUtil.cleanup((Connection)connection);
        }
    }
}

