/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.CredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.CredentialWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProxyCredential
extends AbstractResourceSecurityWrapper<X509Credential>
implements CredentialWrapper {
    private Log logger = LogFactory.getLog((String)this.getClass().getCanonicalName());

    public ResourceProxyCredential(String locationPattern) throws ResourceStoreException {
        super(false);
        this.init(locationPattern);
    }

    public ResourceProxyCredential(GlobusResource globusResource) throws ResourceStoreException {
        super(false);
        this.init(globusResource);
    }

    public ResourceProxyCredential(String filename, X509Credential object) throws ResourceStoreException {
        super(false);
        this.init(filename, object);
    }

    public ResourceProxyCredential(boolean inMemory, GlobusResource globusResource, X509Credential object) throws ResourceStoreException {
        super(inMemory);
        this.init(globusResource, object);
    }

    @Override
    public X509Credential getCredential() throws ResourceStoreException {
        return (X509Credential)this.getSecurityObject();
    }

    @Override
    protected X509Credential create(GlobusResource globusResource) throws ResourceStoreException {
        BufferedInputStream keyInputStream = null;
        InputStream certInputStream = null;
        try {
            keyInputStream = new BufferedInputStream(globusResource.getInputStream());
            certInputStream = new BufferedInputStream(globusResource.getInputStream());
            X509Credential x509Credential = new X509Credential(keyInputStream, certInputStream);
            return x509Credential;
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (CredentialException e) {
            throw new ResourceStoreException(e);
        }
        finally {
            if (keyInputStream != null) {
                try {
                    ((InputStream)keyInputStream).close();
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Unable to close stream.");
                }
            }
            if (certInputStream != null) {
                try {
                    certInputStream.close();
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Unable to close stream.");
                }
            }
        }
    }

    @Override
    public void store() throws ResourceStoreException {
        try {
            X509Credential credential = this.getCredential();
            credential.writeToFile(this.globusResource.getFile());
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
        catch (CertificateEncodingException e) {
            throw new ResourceStoreException(e);
        }
    }
}

