/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificateLoadUtil {
    private static Log logger;
    private static String provider;

    private CertificateLoadUtil() {
    }

    public static void init() {
    }

    public static void setProvider(String providerName) {
        provider = providerName;
        logger.debug((Object)("Provider set to : " + providerName));
    }

    protected static CertificateFactory getCertificateFactory() throws GeneralSecurityException {
        if (provider == null) {
            return CertificateFactory.getInstance("X.509");
        }
        return CertificateFactory.getInstance("X.509", provider);
    }

    public static X509Certificate loadCertificate(InputStream in) throws GeneralSecurityException {
        return (X509Certificate)CertificateLoadUtil.getCertificateFactory().generateCertificate(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            throw new IllegalArgumentException("Certificate file is null");
        }
        X509Certificate cert = null;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            cert = CertificateLoadUtil.readCertificate(reader);
        }
        finally {
            reader.close();
        }
        if (cert == null) {
            throw new GeneralSecurityException("No certificate data");
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] loadCertificates(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            throw new IllegalArgumentException("Certificate file is null");
        }
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        X509Certificate cert = CertificateLoadUtil.readCertificate(reader);
        try {
            while (cert != null) {
                list.add(cert);
                cert = CertificateLoadUtil.readCertificate(reader);
            }
        }
        finally {
            reader.close();
        }
        if (list.size() == 0) {
            throw new GeneralSecurityException("No certificate data");
        }
        int size = list.size();
        return list.toArray(new X509Certificate[size]);
    }

    public static X509Certificate readCertificate(BufferedReader reader) throws IOException, GeneralSecurityException {
        String line;
        StringBuffer buff = new StringBuffer();
        boolean isCert = false;
        boolean isKey = false;
        boolean notNull = false;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("BEGIN RSA PRIVATE KEY") != -1 || line.indexOf("BEGIN PRIVATE KEY") != -1) {
                isKey = true;
                continue;
            }
            if (isKey && (line.indexOf("END RSA PRIVATE KEY") != -1 || line.indexOf("END PRIVATE KEY") != -1)) {
                isKey = false;
                continue;
            }
            if (isKey) continue;
            notNull = true;
            if (line.indexOf("BEGIN CERTIFICATE") != -1) {
                isCert = true;
                continue;
            }
            if (isCert && line.indexOf("END CERTIFICATE") != -1) {
                byte[] data = Base64.decode((byte[])buff.toString().getBytes());
                return CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(data));
            }
            if (!isCert) continue;
            buff.append(line);
        }
        if (notNull && !isCert) {
            throw new GeneralSecurityException("Certificate needs to start with  BEGIN CERTIFICATE");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509CRL loadCrl(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            throw new IllegalArgumentException("crlFileNull");
        }
        boolean isCrl = false;
        X509CRL crl = null;
        StringBuffer buff = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("BEGIN X509 CRL") != -1) {
                    isCrl = true;
                    continue;
                }
                if (isCrl && line.indexOf("END X509 CRL") != -1) {
                    byte[] data = Base64.decode((byte[])buff.toString().getBytes());
                    crl = CertificateLoadUtil.loadCrl(new ByteArrayInputStream(data));
                    continue;
                }
                if (!isCrl) continue;
                buff.append(line);
            }
        }
        finally {
            reader.close();
        }
        if (crl == null) {
            throw new GeneralSecurityException("noCrlsData");
        }
        return crl;
    }

    public static X509CRL loadCrl(InputStream in) throws GeneralSecurityException {
        return (X509CRL)CertificateLoadUtil.getCertificateFactory().generateCRL(in);
    }

    public static Collection<X509Certificate> getTrustedCertificates(KeyStore keyStore, X509CertSelector selector) throws KeyStoreException {
        Vector<X509Certificate> certificates = new Vector<X509Certificate>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate certificate;
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            X509Certificate x509Cert = (X509Certificate)certificate;
            if (selector == null) {
                certificates.add(x509Cert);
                continue;
            }
            if (!selector.match(certificate)) continue;
            certificates.add(x509Cert);
        }
        return certificates;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = LogFactory.getLog((String)CertificateLoadUtil.class.getCanonicalName());
        CertificateLoadUtil.setProvider("BC");
    }
}

