/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.clustering.NodeGroupLock;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistry;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryRealm;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class EmbeddedRegistryService
implements RegistryService {
    private static final Log log = LogFactory.getLog(EmbeddedRegistryService.class);
    private EmbeddedRegistry embeddedRegistry;
    private RealmService realmService;
    private String chroot;
    protected RegistryContext registryContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbeddedRegistryService(RegistryContext context) throws RegistryException {
        this.registryContext = context;
        long start = System.nanoTime();
        this.configure(context.getRealmService());
        if (log.isInfoEnabled()) {
            try {
                Connection connection = ((JDBCDataAccessManager)context.getDataAccessManager()).getDataSource().getConnection();
                try {
                    String jdbcURL = connection.getMetaData().getURL();
                    Iterator<String> dbConfigNames = context.getDBConfigNames();
                    while (dbConfigNames.hasNext()) {
                        String name = dbConfigNames.next();
                        DataBaseConfiguration configuration = context.getDBConfig(name);
                        if (jdbcURL == null || !jdbcURL.equals(configuration.getDbUrl())) continue;
                        String dbConfigName = configuration.getConfigName();
                        DataBaseConfiguration defaultDBConfiguration = context.getDefaultDataBaseConfiguration();
                        if (dbConfigName != null && defaultDBConfiguration != null && dbConfigName.equals(defaultDBConfiguration.getConfigName())) {
                            log.info((Object)("Configured Registry in " + (System.nanoTime() - start) / 1000000L + "ms"));
                            continue;
                        }
                        log.info((Object)("Connected to mount at " + dbConfigName + " in " + (System.nanoTime() - start) / 1000000L + "ms"));
                    }
                }
                finally {
                    connection.close();
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
        }
    }

    protected EmbeddedRegistryService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(RealmService realmService) throws RegistryException {
        DataAccessManager dataAccessManager;
        if (realmService == null) {
            String msg = "The realm service is not available.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        this.realmService = realmService;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Configuring the embedded registry.");
        }
        if (!((dataAccessManager = this.registryContext.getDataAccessManager()) instanceof JDBCDataAccessManager)) {
            String msg = "Failed to configure the embedded registry. Invalid data access manager.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        NodeGroupLock.init(dataAccessManager);
        Transaction.init(dataAccessManager);
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Obtaining a cluster wide database lock.");
            }
            NodeGroupLock.lock("INITIALIZE");
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cluster wide database lock obtained successfully.");
            }
            if (this.registryContext.isSetup()) {
                if (!dataAccessManager.isDatabaseExisting()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Creating database tables.");
                    }
                    try {
                        dataAccessManager.createDatabase();
                    }
                    catch (Exception ex) {
                        String msg = "Error occurred while creating the database";
                        log.error((Object)msg);
                        throw new RegistryException(msg, ex);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Database tables created successfully.");
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace((Object)"Continue the use of existing database tables");
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)"Registry is not initialized in setup mode. Registry database tables will not be created.");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Creating the JDBC Registry instance ..");
            }
            this.embeddedRegistry = new EmbeddedRegistry(this.registryContext, realmService);
            this.chroot = this.embeddedRegistry.getRegistryContext().getRegistryRoot();
            if (!this.registryContext.isClone()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Adding mount collection and register mount points.");
                }
                UserRegistry systemRegistry = this.getSystemRegistry();
                RegistryUtils.addMountCollection(systemRegistry);
                RegistryUtils.registerMountPoints(systemRegistry, -1234);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"JDBC Registry instance created successfully.");
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Releasing a cluster wide database lock.");
            }
            NodeGroupLock.unlock("INITIALIZE");
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cluster wide database lock released successfully.");
            }
        }
    }

    @Override
    public UserRegistry getUserRegistry() throws RegistryException {
        return this.getUserRegistry("wso2.anonymous.user", -1234);
    }

    @Override
    public UserRegistry getSystemRegistry() throws RegistryException {
        return this.getSystemRegistry(-1234);
    }

    @Override
    public UserRegistry getSystemRegistry(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, null);
    }

    @Override
    public UserRegistry getSystemRegistry(int tenantId, String chroot) throws RegistryException {
        String username = "wso2.system.user";
        return this.getUserRegistry(username, tenantId, chroot);
    }

    @Override
    public UserRegistry getUserRegistry(String userName, String password) throws RegistryException {
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            userName = MultitenantUtils.getTenantAwareUsername((String)userName);
            int tenantId = -1234;
            if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
            }
            return this.getUserRegistry(userName, password, tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Failed in retrieving the tenant id for the tenant domain for " + userName;
            log.error((Object)msg);
            throw new RegistryException(msg, e);
        }
    }

    @Override
    public UserRegistry getUserRegistry(String userName, String password, int tenantId) throws RegistryException {
        return this.getUserRegistry(userName, password, tenantId, null);
    }

    @Override
    public UserRegistry getUserRegistry(String userName, String password, int tenantId, String chroot) throws RegistryException {
        String concatenatedChroot = RegistryUtils.concatenateChroot(this.chroot, chroot);
        return new UserRegistry(userName, password, tenantId, this.embeddedRegistry, this.realmService, concatenatedChroot);
    }

    @Override
    public UserRegistry getUserRegistry(String userName) throws RegistryException {
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            userName = MultitenantUtils.getTenantAwareUsername((String)userName);
            int tenantId = -1234;
            if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
            }
            return this.getUserRegistry(userName, tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Failed in retrieving the tenant id for the tenant for user " + userName;
            log.error((Object)msg);
            throw new RegistryException(msg, e);
        }
    }

    @Override
    public UserRegistry getUserRegistry(String userName, int tenantId) throws RegistryException {
        return this.getUserRegistry(userName, tenantId, null);
    }

    @Override
    public UserRegistry getUserRegistry(String userName, int tenantId, String chroot) throws RegistryException {
        String concatenatedChroot = RegistryUtils.concatenateChroot(this.chroot, chroot);
        return new UserRegistry(userName, tenantId, this.embeddedRegistry, this.realmService, concatenatedChroot);
    }

    @Override
    public UserRealm getUserRealm(int tenantId) throws RegistryException {
        try {
            UserRealm realm = (UserRealm)this.realmService.getTenantUserRealm(tenantId);
            RegistryRealm regRealm = new RegistryRealm(realm);
            return regRealm;
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    public UserRegistry getRegistry(String userName, int tenantId, String chroot) throws RegistryException {
        return this.getUserRegistry(userName, tenantId, chroot);
    }

    @Override
    public UserRegistry getRegistry(String userName, String password, int tenantId, String chroot) throws RegistryException {
        return this.getUserRegistry(userName, password, tenantId, chroot);
    }

    @Override
    public UserRegistry getRegistry() throws RegistryException {
        return this.getRegistry("wso2.anonymous.user");
    }

    @Override
    public UserRegistry getRegistry(String userName) throws RegistryException {
        return this.getRegistry(userName, -1234);
    }

    @Override
    public UserRegistry getRegistry(String userName, int tenantId) throws RegistryException {
        return this.getRegistry(userName, tenantId, null);
    }

    @Override
    public UserRegistry getRegistry(String userName, String password) throws RegistryException {
        return this.getRegistry(userName, password, -1234);
    }

    @Override
    public UserRegistry getRegistry(String userName, String password, int tenantId) throws RegistryException {
        return this.getRegistry(userName, password, tenantId, null);
    }

    @Override
    public UserRegistry getLocalRepository() throws RegistryException {
        return this.getLocalRepository(-1234);
    }

    @Override
    public UserRegistry getLocalRepository(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, "/_system/local");
    }

    @Override
    public UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, "/_system/config");
    }

    @Override
    public UserRegistry getConfigSystemRegistry() throws RegistryException {
        return this.getConfigSystemRegistry(-1234);
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName, int tenantId) throws RegistryException {
        return this.getRegistry(userName, tenantId, "/_system/config");
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName, String password, int tenantId) throws RegistryException {
        return this.getRegistry(userName, password, tenantId, "/_system/config");
    }

    @Override
    public UserRegistry getConfigUserRegistry() throws RegistryException {
        return this.getConfigUserRegistry("wso2.anonymous.user");
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName) throws RegistryException {
        return this.getConfigUserRegistry(userName, -1234);
    }

    @Override
    public UserRegistry getConfigUserRegistry(String userName, String password) throws RegistryException {
        return this.getConfigUserRegistry(userName, password, -1234);
    }

    @Override
    public UserRegistry getGovernanceSystemRegistry(int tenantId) throws RegistryException {
        return this.getSystemRegistry(tenantId, "/_system/governance");
    }

    @Override
    public UserRegistry getGovernanceSystemRegistry() throws RegistryException {
        return this.getGovernanceSystemRegistry(-1234);
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName, int tenantId) throws RegistryException {
        return this.getRegistry(userName, tenantId, "/_system/governance");
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName, String password, int tenantId) throws RegistryException {
        return this.getRegistry(userName, password, tenantId, "/_system/governance");
    }

    @Override
    public UserRegistry getGovernanceUserRegistry() throws RegistryException {
        return this.getGovernanceUserRegistry("wso2.anonymous.user");
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName) throws RegistryException {
        return this.getGovernanceUserRegistry(userName, -1234);
    }

    @Override
    public UserRegistry getGovernanceUserRegistry(String userName, String password) throws RegistryException {
        return this.getGovernanceUserRegistry(userName, password, -1234);
    }
}

