/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import java.util.ArrayList;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class RatingCollectionURLHandler
extends Handler {
    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        ResourceDAO resourceDAO = registryContext.getDataAccessManager().getDAOManager().getResourceDAO();
        RatingsDAO ratingsDAO = registryContext.getDataAccessManager().getDAOManager().getRatingsDAO(StaticConfiguration.isVersioningRatings());
        ResourcePath resourcePath = requestContext.getResourcePath();
        if (resourcePath.parameterExists("ratings") && resourcePath.getParameterValue("ratings") == null) {
            ResourceImpl resourceImpl = resourceDAO.getResourceMetaData(resourcePath.getPath());
            String[] ratedUserNames = ratingsDAO.getRatedUserNames(resourceImpl);
            CollectionImpl resource = new CollectionImpl();
            resource.setPath(resourcePath.getCompletePath());
            ArrayList<String> ratingPaths = new ArrayList<String>();
            for (String ratedUserName : ratedUserNames) {
                String ratingPath = resourcePath.getPath() + ";" + "ratings:" + ratedUserName;
                ratingPaths.add(ratingPath);
            }
            String[] ratingsContent = ratingPaths.toArray(new String[ratingPaths.size()]);
            resource.setContent(ratingsContent);
            requestContext.setProcessingComplete(true);
            return resource;
        }
        return null;
    }
}

