/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class RegexBaseRestrictionHandler
extends Handler {
    private Set<PatternAdapter> regexPatterns = new HashSet<PatternAdapter>();
    private static final String SYS_COLLECTION_RESTRICTION_REGEX = "^/_system((/config|/local|/governance)?)$";
    private static final String ERROR_MSG = "This operation cannot be performed on resource: %s.";
    private static final Log log = LogFactory.getLog(RegexBaseRestrictionHandler.class);

    public RegexBaseRestrictionHandler() {
        this.addRegExPattern(SYS_COLLECTION_RESTRICTION_REGEX);
    }

    public RegexBaseRestrictionHandler(Set<String> regexPatterns) {
        this();
        for (String regexPattern : regexPatterns) {
            this.addRegExPattern(regexPattern);
        }
    }

    public void addRegExPattern(String regExPattern) {
        this.regexPatterns.add(new PatternAdapter(Pattern.compile(regExPattern)));
    }

    @Override
    public String move(RequestContext requestContext) throws RegistryException {
        log.trace((Object)"Performing a move operation.");
        this.validatePath(requestContext);
        return requestContext.getTargetPath();
    }

    @Override
    public String rename(RequestContext requestContext) throws RegistryException {
        log.trace((Object)"Performing a rename operation.");
        this.validatePath(requestContext);
        return requestContext.getTargetPath();
    }

    private boolean validatePath(RequestContext requestContext) throws RegistryException {
        String resourcePath = requestContext.getSourcePath();
        log.debug((Object)("Resource validation: " + resourcePath));
        for (PatternAdapter pa : this.regexPatterns) {
            if (!pa.getPattern().matcher(resourcePath).find()) continue;
            requestContext.setProcessingComplete(true);
            String errMsg = String.format(ERROR_MSG, resourcePath);
            log.error((Object)errMsg);
            throw new RegistryException(errMsg);
        }
        return true;
    }

    private static class PatternAdapter {
        private Pattern pattern;

        private PatternAdapter(Pattern p) {
            this.pattern = p;
        }

        private Pattern getPattern() {
            return this.pattern;
        }

        public int hashCode() {
            return this.pattern.pattern().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PatternAdapter) {
                PatternAdapter other = (PatternAdapter)obj;
                return this.pattern.pattern().equals(other.pattern.pattern());
            }
            return false;
        }
    }
}

