/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class SQLQueryHandler
extends Handler {
    private static final Log log = LogFactory.getLog(SQLQueryHandler.class);
    private ThreadLocal<Boolean> inExecution = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private Boolean isInExecution() {
        return this.inExecution.get();
    }

    private void setInExecution(Boolean input) {
        this.inExecution.set(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            return super.get(requestContext);
        }
        this.setInExecution(true);
        try {
            String queryPath = requestContext.getResourcePath().getPath();
            Resource resource = requestContext.getRegistry().get(queryPath);
            Object content = resource.getContent();
            if (content instanceof byte[]) {
                resource.setContent(RegistryUtils.decodeBytes((byte[])content));
            }
            requestContext.setProcessingComplete(true);
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            this.setInExecution(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        if (this.isInExecution().booleanValue()) {
            super.put(requestContext);
            return;
        }
        this.setInExecution(true);
        try {
            if (!RegistryUtils.hasAdminAuthorizations(CurrentSession.getUser(), CurrentSession.getUserRealm())) {
                String msg = "User " + CurrentSession.getUser() + " does not have necessary authorizations to add or modify queries.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            Resource resource = requestContext.getResource();
            Object content = resource.getContent();
            if (content instanceof String) {
                String textContent = (String)content;
                resource.setContent(RegistryUtils.encodeString(textContent));
            }
            String queryPath = requestContext.getResourcePath().getPath();
            requestContext.getRegistry().put(queryPath, resource);
            requestContext.setProcessingComplete(true);
        }
        finally {
            this.setInExecution(false);
        }
    }
}

