/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DumpWriter
extends Writer {
    private static final Log log = LogFactory.getLog(DumpWriter.class);
    private Writer writer;
    private boolean writeDirectly;
    private int quotesCount;
    private StringBuffer strBuffer;
    private List<String> bufferedAttributes;

    public DumpWriter(Writer writer) {
        this.writer = writer;
        this.writeDirectly = false;
        this.quotesCount = 0;
        this.strBuffer = new StringBuffer();
        this.bufferedAttributes = new ArrayList<String>();
    }

    @Override
    public void write(char[] cBuf, int off, int len) throws IOException {
        if (this.writeDirectly) {
            this.writer.write(cBuf, off, len);
            return;
        }
        int minLen = cBuf.length - off < len ? cBuf.length - off : len;
        for (int i = 0; i < minLen; ++i) {
            char c = cBuf[off + i];
            if (this.writeDirectly) {
                this.writer.write(c);
                continue;
            }
            if (c == '\"') {
                ++this.quotesCount;
            }
            this.strBuffer.append(c);
            if (this.quotesCount != 2) continue;
            String buffer = this.strBuffer.toString();
            int lastEqualIndex = (buffer = buffer.trim()).lastIndexOf(61);
            if (lastEqualIndex == 1) {
                String msg = "Error in written xml. attribute should serialize with '='.";
                log.error((Object)msg);
                throw new IOException(msg);
            }
            String beforeEqualBuffer = buffer.substring(0, lastEqualIndex);
            beforeEqualBuffer = beforeEqualBuffer.trim();
            int lastSpaceIndex = beforeEqualBuffer.lastIndexOf(32);
            if (lastEqualIndex == -1) {
                String msg = "Error in written xml. attribute should serialize with ' ' at the start.";
                log.error((Object)msg);
                throw new IOException(msg);
            }
            String attributeName = beforeEqualBuffer.substring(lastSpaceIndex + 1);
            if (attributeName.equals("name")) {
                this.writeDirectly = true;
                for (String bufferedAttribute : this.bufferedAttributes) {
                    this.writer.write(" " + bufferedAttribute);
                }
                continue;
            }
            this.quotesCount = 0;
            String attributeWithValue = buffer.substring(lastSpaceIndex + 1);
            this.bufferedAttributes.add(attributeWithValue);
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
    }
}

