/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.events;

import java.lang.reflect.Array;
import java.util.Map;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.Resource;
import org.compass.core.config.CompassAware;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassMappingAware;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.events.FilterOperation;
import org.compass.core.events.PostCreateEventListener;
import org.compass.core.events.PostCreateResourceEventListener;
import org.compass.core.events.PostDeleteEventListener;
import org.compass.core.events.PostDeleteResourceEventListener;
import org.compass.core.events.PostSaveEventListener;
import org.compass.core.events.PostSaveResourceEventListener;
import org.compass.core.events.PreCreateEventListener;
import org.compass.core.events.PreCreateResourceEventListener;
import org.compass.core.events.PreDeleteEventListener;
import org.compass.core.events.PreDeleteResourceEventListener;
import org.compass.core.events.PreSaveEventListener;
import org.compass.core.events.PreSaveResourceEventListener;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.AliasedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompassEventManager
implements CompassConfigurable,
PreCreateEventListener,
PreDeleteEventListener,
PreSaveEventListener,
PostCreateEventListener,
PostDeleteEventListener,
PostSaveEventListener,
PreCreateResourceEventListener,
PreSaveResourceEventListener,
PreDeleteResourceEventListener,
PostCreateResourceEventListener,
PostSaveResourceEventListener,
PostDeleteResourceEventListener {
    private CompassMapping mapping;
    private Compass compass;
    private PreCreateEventListener[] preCreateEventListeners;
    private PreDeleteEventListener[] preDeleteEventListeners;
    private PreSaveEventListener[] preSaveEventListeners;
    private PostCreateEventListener[] postCreateEventListeners;
    private PostSaveEventListener[] postSaveEventListeners;
    private PostDeleteEventListener[] postDeleteEventListeners;
    private PreCreateResourceEventListener[] preCreateResourceEventListeners;
    private PreSaveResourceEventListener[] preSaveResourceEventListeners;
    private PreDeleteResourceEventListener[] preDeleteResourceEventListeners;
    private PostCreateResourceEventListener[] postCreateResourceEventListeners;
    private PostSaveResourceEventListener[] postSaveResourceEventListeners;
    private PostDeleteResourceEventListener[] postDeleteResourceEventListeners;

    public CompassEventManager(Compass compass, CompassMapping mapping) {
        this.compass = compass;
        this.mapping = mapping;
    }

    @Override
    public void configure(CompassSettings settings) throws CompassException {
        this.preCreateEventListeners = this.configureListener(settings, "compass.event.preCreate", PreCreateEventListener.class);
        this.preDeleteEventListeners = this.configureListener(settings, "compass.event.preDelete", PreDeleteEventListener.class);
        this.preSaveEventListeners = this.configureListener(settings, "compass.event.preSave", PreSaveEventListener.class);
        this.preCreateResourceEventListeners = this.configureListener(settings, "compass.event.preCreateResource", PreCreateResourceEventListener.class);
        this.preDeleteResourceEventListeners = this.configureListener(settings, "compass.event.preDeleteResource", PreDeleteResourceEventListener.class);
        this.preSaveResourceEventListeners = this.configureListener(settings, "compass.event.preSaveResource", PreSaveResourceEventListener.class);
        this.postCreateEventListeners = this.configureListener(settings, "compass.event.postCreate", PostCreateEventListener.class);
        this.postDeleteEventListeners = this.configureListener(settings, "compass.event.postDelete", PostDeleteEventListener.class);
        this.postSaveEventListeners = this.configureListener(settings, "compass.event.postSave", PostSaveEventListener.class);
        this.postCreateResourceEventListeners = this.configureListener(settings, "compass.event.postCreateResource", PostCreateResourceEventListener.class);
        this.postDeleteResourceEventListeners = this.configureListener(settings, "compass.event.postDeleteResource", PostDeleteResourceEventListener.class);
        this.postSaveResourceEventListeners = this.configureListener(settings, "compass.event.postSaveResource", PostSaveResourceEventListener.class);
    }

    private <T> T[] configureListener(CompassSettings settings, String settingPrefix, Class<T> type) {
        Map<String, CompassSettings> listenerSettings = settings.getSettingGroups(settingPrefix);
        if (listenerSettings.size() == 0) {
            return null;
        }
        Object[] listeners = (Object[])Array.newInstance(type, listenerSettings.size());
        int count = 0;
        for (Map.Entry<String, CompassSettings> entry : listenerSettings.entrySet()) {
            Object listener = entry.getValue().getSettingAsInstance("type");
            if (listener == null) {
                throw new ConfigurationException("type is required when configuring the [" + entry.getKey() + "] event");
            }
            if (listener instanceof CompassMappingAware) {
                ((CompassMappingAware)listener).setCompassMapping(this.mapping);
            }
            if (listener instanceof CompassAware) {
                ((CompassAware)listener).setCompass(this.compass);
            }
            listeners[count++] = listener;
        }
        return listeners;
    }

    @Override
    public FilterOperation onPreCreate(String alias, Object obj) {
        alias = this.findAlias(alias, obj);
        if (this.preCreateEventListeners == null) {
            return FilterOperation.NO;
        }
        for (PreCreateEventListener listener : this.preCreateEventListeners) {
            if (listener.onPreCreate(alias, obj) != FilterOperation.YES) continue;
            return FilterOperation.YES;
        }
        return FilterOperation.NO;
    }

    @Override
    public FilterOperation onPreCreate(Resource resource) {
        if (this.preCreateResourceEventListeners == null) {
            return FilterOperation.NO;
        }
        for (PreCreateResourceEventListener listener : this.preCreateResourceEventListeners) {
            if (listener.onPreCreate(resource) != FilterOperation.YES) continue;
            return FilterOperation.YES;
        }
        return FilterOperation.NO;
    }

    @Override
    public FilterOperation onPreDelete(String alias, Object obj) {
        alias = this.findAlias(alias, obj);
        if (this.preDeleteEventListeners == null) {
            return FilterOperation.NO;
        }
        for (PreDeleteEventListener listener : this.preDeleteEventListeners) {
            if (listener.onPreDelete(alias, obj) != FilterOperation.YES) continue;
            return FilterOperation.YES;
        }
        return FilterOperation.NO;
    }

    public FilterOperation onPreDelete(Class clazz, Object obj) {
        String alias = this.findAlias(clazz, obj);
        if (this.preDeleteEventListeners == null) {
            return FilterOperation.NO;
        }
        for (PreDeleteEventListener listener : this.preDeleteEventListeners) {
            if (listener.onPreDelete(alias, obj) != FilterOperation.YES) continue;
            return FilterOperation.YES;
        }
        return FilterOperation.NO;
    }

    @Override
    public FilterOperation onPreDelete(Resource resource) {
        if (this.preDeleteResourceEventListeners == null) {
            return FilterOperation.NO;
        }
        for (PreDeleteResourceEventListener listener : this.preDeleteResourceEventListeners) {
            if (listener.onPreDelete(resource) != FilterOperation.YES) continue;
            return FilterOperation.YES;
        }
        return FilterOperation.NO;
    }

    @Override
    public FilterOperation onPreSave(String alias, Object obj) {
        alias = this.findAlias(alias, obj);
        if (this.preSaveEventListeners == null) {
            return FilterOperation.NO;
        }
        for (PreSaveEventListener listener : this.preSaveEventListeners) {
            if (listener.onPreSave(alias, obj) != FilterOperation.YES) continue;
            return FilterOperation.YES;
        }
        return FilterOperation.NO;
    }

    @Override
    public FilterOperation onPreSave(Resource resource) {
        if (this.preSaveResourceEventListeners == null) {
            return FilterOperation.NO;
        }
        for (PreSaveResourceEventListener listener : this.preSaveResourceEventListeners) {
            if (listener.onPreSave(resource) != FilterOperation.YES) continue;
            return FilterOperation.YES;
        }
        return FilterOperation.NO;
    }

    @Override
    public void onPostCreate(String alias, Object obj) {
        alias = this.findAlias(alias, obj);
        if (this.postCreateEventListeners == null) {
            return;
        }
        for (PostCreateEventListener listener : this.postCreateEventListeners) {
            listener.onPostCreate(alias, obj);
        }
    }

    @Override
    public void onPostCreate(Resource resource) {
        if (this.postCreateResourceEventListeners == null) {
            return;
        }
        for (PostCreateResourceEventListener listener : this.postCreateResourceEventListeners) {
            listener.onPostCreate(resource);
        }
    }

    @Override
    public void onPostDelete(String alias, Object obj) {
        alias = this.findAlias(alias, obj);
        if (this.postDeleteEventListeners == null) {
            return;
        }
        for (PostDeleteEventListener listener : this.postDeleteEventListeners) {
            listener.onPostDelete(alias, obj);
        }
    }

    public void onPostDelete(Class clazz, Object obj) {
        String alias = this.findAlias(clazz, obj);
        if (this.postDeleteEventListeners == null) {
            return;
        }
        for (PostDeleteEventListener listener : this.postDeleteEventListeners) {
            listener.onPostDelete(alias, obj);
        }
    }

    @Override
    public void onPostDelete(Resource resource) {
        if (this.postDeleteResourceEventListeners == null) {
            return;
        }
        for (PostDeleteResourceEventListener listener : this.postDeleteResourceEventListeners) {
            listener.onPostDelete(resource);
        }
    }

    @Override
    public void onPostSave(String alias, Object obj) {
        alias = this.findAlias(alias, obj);
        if (this.postSaveEventListeners == null) {
            return;
        }
        for (PostSaveEventListener listener : this.postSaveEventListeners) {
            listener.onPostSave(alias, obj);
        }
    }

    @Override
    public void onPostSave(Resource resource) {
        if (this.postSaveResourceEventListeners == null) {
            return;
        }
        for (PostSaveResourceEventListener listener : this.postSaveResourceEventListeners) {
            listener.onPostSave(resource);
        }
    }

    private String findAlias(String alias, Object obj) {
        if (alias != null) {
            return alias;
        }
        if (obj instanceof AliasedObject) {
            return ((AliasedObject)obj).getAlias();
        }
        ResourceMapping resourceMapping = this.mapping.getMappingByClass(obj.getClass());
        if (resourceMapping == null) {
            throw new CompassException("Can't derive alias from [" + obj + "]");
        }
        return resourceMapping.getAlias();
    }

    private String findAlias(Class clazz, Object obj) {
        if (obj instanceof AliasedObject) {
            return ((AliasedObject)obj).getAlias();
        }
        ResourceMapping resourceMapping = this.mapping.getMappingByClass(clazz);
        if (resourceMapping == null) {
            throw new CompassException("Can't derive alias from [" + obj + "]");
        }
        return resourceMapping.getAlias();
    }
}

