/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.compass.core.util.config.ConfigurationHelper;
import org.compass.core.util.config.XmlConfigurationHelper;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigurationHelperUtil {
    private ConfigurationHelperUtil() {
    }

    public static ConfigurationHelper toConfiguration(Element element) {
        XmlConfigurationHelper configuration = new XmlConfigurationHelper(element.getNodeName(), "dom-created");
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = attributes.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            configuration.setAttribute(name, value);
        }
        boolean flag = false;
        String content = "";
        NodeList nodes = element.getChildNodes();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                ConfigurationHelper child = ConfigurationHelperUtil.toConfiguration((Element)node);
                configuration.addChild(child);
                continue;
            }
            if (!(node instanceof CharacterData)) continue;
            CharacterData data = (CharacterData)node;
            content = content + data.getData();
            flag = true;
        }
        if (flag) {
            configuration.setValue(content);
        }
        return configuration;
    }

    public static Element toElement(ConfigurationHelper configuration) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            return ConfigurationHelperUtil.createElement(document, configuration);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    public static boolean equals(ConfigurationHelper c1, ConfigurationHelper c2) {
        return c1.getName().equals(c2.getName()) && ConfigurationHelperUtil.areValuesEqual(c1, c2) && ConfigurationHelperUtil.areAttributesEqual(c1, c2) && ConfigurationHelperUtil.areChildrenEqual(c1, c2);
    }

    private static boolean areChildrenEqual(ConfigurationHelper c1, ConfigurationHelper c2) {
        ArrayList<ConfigurationHelper> kids2;
        ConfigurationHelper[] kids1 = c1.getChildren();
        if (kids1.length != (kids2 = new ArrayList<ConfigurationHelper>(Arrays.asList(c2.getChildren()))).size()) {
            return false;
        }
        for (int i = 0; i < kids1.length; ++i) {
            if (ConfigurationHelperUtil.findMatchingChild(kids1[i], kids2)) continue;
            return false;
        }
        return kids2.isEmpty();
    }

    private static boolean findMatchingChild(ConfigurationHelper c, ArrayList matchAgainst) {
        Iterator i = matchAgainst.iterator();
        while (i.hasNext()) {
            if (!ConfigurationHelperUtil.equals(c, (ConfigurationHelper)i.next())) continue;
            i.remove();
            return true;
        }
        return false;
    }

    private static boolean areAttributesEqual(ConfigurationHelper c1, ConfigurationHelper c2) {
        String[] names2;
        String[] names1 = c1.getAttributeNames();
        if (names1.length != (names2 = c2.getAttributeNames()).length) {
            return false;
        }
        for (int i = 0; i < names1.length; ++i) {
            String value2;
            String name = names1[i];
            String value1 = c1.getAttribute(name, null);
            if (value1.equals(value2 = c2.getAttribute(name, null))) continue;
            return false;
        }
        return true;
    }

    private static boolean areValuesEqual(ConfigurationHelper c1, ConfigurationHelper c2) {
        String value1 = c1.getValue(null);
        String value2 = c2.getValue(null);
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    private static Element createElement(Document document, ConfigurationHelper configuration) {
        Element element = document.createElement(configuration.getName());
        String content = configuration.getValue(null);
        if (null != content) {
            Text child = document.createTextNode(content);
            element.appendChild(child);
        }
        String[] names = configuration.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String value = configuration.getAttribute(name, null);
            element.setAttribute(name, value);
        }
        ConfigurationHelper[] children = configuration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Element child = ConfigurationHelperUtil.createElement(document, children[i]);
            element.appendChild(child);
        }
        return element;
    }
}

