/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.indexer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassSession;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.indexer.JpaIndexEntitiesIndexer;
import org.compass.gps.device.jpa.queryprovider.HibernateJpaQueryProvider;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.ejb.HibernateQuery;
import org.hibernate.metadata.ClassMetadata;

public class HibernateJpaIndexEntitiesIndexer
implements JpaIndexEntitiesIndexer {
    private static final Log log = LogFactory.getLog(HibernateJpaIndexEntitiesIndexer.class);
    private JpaGpsDevice jpaGpsDevice;
    private boolean performOrderById = true;
    private Map<String, Boolean> performOrderByPerEntity = new HashMap<String, Boolean>();

    public void setJpaGpsDevice(JpaGpsDevice jpaGpsDevice) {
        this.jpaGpsDevice = jpaGpsDevice;
    }

    public void setPerformOrderById(boolean performOrderById) {
        this.performOrderById = performOrderById;
    }

    public void setPerformOrderById(String entity, boolean performOrderById) {
        this.performOrderByPerEntity.put(entity, performOrderById);
    }

    public void performIndex(CompassSession session, IndexEntity[] entities) {
        for (IndexEntity indexEntity : entities) {
            EntityInformation entityInformation = (EntityInformation)indexEntity;
            if (this.jpaGpsDevice.isFilteredForIndex(entityInformation.getName())) continue;
            int fetchCount = this.jpaGpsDevice.getFetchCount();
            if (!this.jpaGpsDevice.isRunning()) {
                return;
            }
            EntityManagerWrapper wrapper = this.jpaGpsDevice.getEntityManagerWrapper().newInstance();
            ScrollableResults cursor = null;
            try {
                Criteria criteria;
                wrapper.open();
                HibernateEntityManager entityManager = (HibernateEntityManager)wrapper.getEntityManager();
                entityManager.getSession().setCacheMode(CacheMode.IGNORE);
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.jpaGpsDevice.buildMessage("Indexing entities [" + entityInformation.getName() + "] using query [" + entityInformation.getQueryProvider() + "]"));
                }
                if (entityInformation.getQueryProvider() instanceof HibernateJpaQueryProvider && (criteria = ((HibernateJpaQueryProvider)entityInformation.getQueryProvider()).createCriteria(entityManager, entityInformation)) != null) {
                    ClassMetadata metadata;
                    String idPropName;
                    Boolean performOrder;
                    if (this.performOrderById && ((performOrder = this.performOrderByPerEntity.get(entityInformation.getName())) == null || performOrder.booleanValue()) && (idPropName = (metadata = entityManager.getSession().getSessionFactory().getClassMetadata(entityInformation.getName())).getIdentifierPropertyName()) != null) {
                        criteria.addOrder(Order.asc((String)idPropName));
                    }
                    criteria.setFetchSize(fetchCount);
                    cursor = criteria.scroll(ScrollMode.FORWARD_ONLY);
                }
                if (cursor == null) {
                    HibernateQuery query = (HibernateQuery)entityInformation.getQueryProvider().createQuery((EntityManager)entityManager, entityInformation);
                    cursor = query.getHibernateQuery().scroll(ScrollMode.FORWARD_ONLY);
                }
                RowBuffer buffer = new RowBuffer(session, entityManager.getSession(), fetchCount);
                Object prev = null;
                while (true) {
                    try {
                        if (!cursor.next()) {
                            break;
                        }
                    }
                    catch (ObjectNotFoundException e) {
                        continue;
                    }
                    Object item = cursor.get(0);
                    if (item != prev && prev != null) {
                        buffer.put(prev);
                    }
                    prev = item;
                    if (!buffer.shouldFlush()) continue;
                    buffer.put(prev);
                    buffer.flush();
                    prev = null;
                }
                if (prev != null) {
                    buffer.put(prev);
                }
                buffer.close();
                cursor.close();
                entityManager.clear();
                wrapper.close();
            }
            catch (Exception e) {
                log.error((Object)this.jpaGpsDevice.buildMessage("Failed to index the database"), (Throwable)e);
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Exception e1) {
                        log.warn((Object)this.jpaGpsDevice.buildMessage("Failed to close cursor on error, ignoring"), (Throwable)e1);
                    }
                }
                wrapper.closeOnError();
                if (!(e instanceof JpaGpsDeviceException)) {
                    throw new JpaGpsDeviceException(this.jpaGpsDevice.buildMessage("Failed to index the database"), e);
                }
                throw (JpaGpsDeviceException)e;
            }
        }
    }

    private class RowBuffer {
        private Object[] buffer;
        private int fetchCount;
        private int index = 0;
        private CompassSession compassSession;
        private Session hibernateSession;

        RowBuffer(CompassSession compassSession, Session hibernateSession, int fetchCount) {
            this.compassSession = compassSession;
            this.hibernateSession = hibernateSession;
            this.fetchCount = fetchCount;
            this.buffer = new Object[fetchCount + 1];
        }

        public void put(Object row) {
            this.buffer[this.index] = row;
            ++this.index;
        }

        public boolean shouldFlush() {
            return this.index >= this.fetchCount;
        }

        public void close() {
            this.flush();
            this.buffer = null;
        }

        private void flush() {
            for (int i = 0; i < this.index; ++i) {
                this.compassSession.create(this.buffer[i]);
            }
            Arrays.fill(this.buffer, null);
            this.compassSession.evictAll();
            this.hibernateSession.clear();
            this.index = 0;
        }
    }
}

