/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;

public class Overlay {
    public static final COSName XOBJECT = COSName.getPDFName("XObject");
    public static final COSName PROC_SET = COSName.getPDFName("ProcSet");
    public static final COSName EXT_G_STATE = COSName.getPDFName("ExtGState");
    private List layoutPages = new ArrayList(10);
    private PDDocument pdfOverlay;
    private PDDocument pdfDocument;
    private int pageCount = 0;
    private COSStream saveGraphicsStateStream;
    private COSStream restoreGraphicsStateStream;
    static /* synthetic */ Class class$org$pdfbox$Overlay;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException, COSVisitorException {
        PDDocument pdf;
        block4: {
            if (args.length != 3) {
                Overlay.usage();
                System.exit(1);
                return;
            }
            PDDocument overlay = null;
            pdf = null;
            try {
                overlay = Overlay.getDocument(args[0]);
                pdf = Overlay.getDocument(args[1]);
                Overlay overlayer = new Overlay();
                overlayer.overlay(overlay, pdf);
                Overlay.writeDocument(pdf, args[2]);
                Object var5_4 = null;
                if (overlay == null) break block4;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (overlay != null) {
                    overlay.close();
                }
                if (pdf == null) throw throwable;
                pdf.close();
                throw throwable;
            }
            overlay.close();
        }
        if (pdf == null) return;
        pdf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDocument(PDDocument pdf, String filename) throws IOException, COSVisitorException {
        FileOutputStream output;
        block5: {
            output = null;
            COSWriter writer = null;
            try {
                output = new FileOutputStream(filename);
                writer = new COSWriter(output);
                writer.write(pdf);
                Object var5_4 = null;
                if (writer == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (writer != null) {
                    writer.close();
                }
                if (output != null) {
                    output.close();
                }
                throw throwable;
            }
            writer.close();
        }
        if (output != null) {
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PDDocument getDocument(String filename) throws IOException {
        FileInputStream input = null;
        PDFParser parser = null;
        PDDocument result = null;
        try {
            input = new FileInputStream(filename);
            parser = new PDFParser(input);
            parser.parse();
            result = parser.getPDDocument();
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return result;
    }

    private static void usage() {
        System.err.println("usage: java " + (class$org$pdfbox$Overlay == null ? (class$org$pdfbox$Overlay = Overlay.class$("org.pdfbox.Overlay")) : class$org$pdfbox$Overlay).getName() + "<overlay.pdf> <document.pdf> <result.pdf>");
    }

    public PDDocument overlay(PDDocument overlay, PDDocument destination) throws IOException {
        this.pdfOverlay = overlay;
        this.pdfDocument = destination;
        PDDocumentCatalog overlayCatalog = this.pdfOverlay.getDocumentCatalog();
        this.collectLayoutPages(overlayCatalog.getAllPages());
        COSDictionary saveGraphicsStateDic = new COSDictionary();
        this.saveGraphicsStateStream = new COSStream(saveGraphicsStateDic, this.pdfDocument.getDocument().getScratchFile());
        OutputStream saveStream = this.saveGraphicsStateStream.createUnfilteredStream();
        saveStream.write(" q\n".getBytes());
        saveStream.flush();
        this.restoreGraphicsStateStream = new COSStream(saveGraphicsStateDic, this.pdfDocument.getDocument().getScratchFile());
        OutputStream restoreStream = this.restoreGraphicsStateStream.createUnfilteredStream();
        restoreStream.write(" Q\n".getBytes());
        restoreStream.flush();
        PDDocumentCatalog pdfCatalog = this.pdfDocument.getDocumentCatalog();
        this.processPages(pdfCatalog.getAllPages());
        return this.pdfDocument;
    }

    private void collectLayoutPages(List pages) throws IOException {
        Iterator pagesIter = pages.iterator();
        while (pagesIter.hasNext()) {
            PDPage page = (PDPage)pagesIter.next();
            COSBase contents = page.getCOSDictionary().getDictionaryObject(COSName.CONTENTS);
            PDResources resources = page.findResources();
            if (resources == null) {
                resources = new PDResources();
                page.setResources(resources);
            }
            COSDictionary res = resources.getCOSDictionary();
            if (contents instanceof COSStream) {
                COSStream stream = (COSStream)contents;
                TreeMap objectNameMap = new TreeMap();
                stream = this.makeUniqObjectNames(objectNameMap, stream);
                this.layoutPages.add(new LayoutPage(stream, res, objectNameMap));
                continue;
            }
            if (contents instanceof COSArray) {
                throw new UnsupportedOperationException("Layout pages with COSArray currently not supported.");
            }
            throw new IOException("Contents are unknown type:" + contents.getClass().getName());
        }
    }

    private COSStream makeUniqObjectNames(Map objectNameMap, COSStream stream) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        byte[] buf = new byte[10240];
        InputStream is = stream.getUnfilteredStream();
        while ((read = is.read(buf)) > -1) {
            baos.write(buf, 0, read);
        }
        buf = baos.toByteArray();
        baos = new ByteArrayOutputStream(buf.length + 100);
        StringBuffer sbObjectName = new StringBuffer(10);
        boolean bInObjectIdent = false;
        boolean bInText = false;
        boolean bInEscape = false;
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            if (!bInEscape) {
                if (!bInText && b == 40) {
                    bInText = true;
                }
                if (bInText && b == 41) {
                    bInText = false;
                }
                if (b == 92) {
                    bInEscape = true;
                }
                if (!bInText && !bInEscape) {
                    if (b == 47) {
                        bInObjectIdent = true;
                    } else if (bInObjectIdent && Character.isWhitespace((char)b)) {
                        bInObjectIdent = false;
                        String objectName = sbObjectName.toString().substring(1);
                        String newObjectName = objectName + "overlay";
                        baos.write(47);
                        baos.write(newObjectName.getBytes());
                        objectNameMap.put(objectName, COSName.getPDFName(newObjectName));
                        sbObjectName.delete(0, sbObjectName.length());
                    }
                }
                if (bInObjectIdent) {
                    sbObjectName.append((char)b);
                    continue;
                }
            } else {
                bInEscape = false;
            }
            baos.write(b);
        }
        COSDictionary streamDict = new COSDictionary();
        streamDict.setItem(COSName.LENGTH, (COSBase)new COSInteger(baos.size()));
        COSStream output = new COSStream(streamDict, this.pdfDocument.getDocument().getScratchFile());
        output.setFilters(stream.getFilters());
        OutputStream os = output.createUnfilteredStream();
        baos.writeTo(os);
        os.close();
        return output;
    }

    private void processPages(List pages) throws IOException {
        Iterator pageIter = pages.iterator();
        while (pageIter.hasNext()) {
            PDPage page = (PDPage)pageIter.next();
            COSDictionary pageDictionary = page.getCOSDictionary();
            COSBase contents = pageDictionary.getDictionaryObject(COSName.CONTENTS);
            if (contents instanceof COSStream) {
                COSStream contentsStream = (COSStream)contents;
                ++this.pageCount;
                COSArray array = new COSArray();
                array.add(contentsStream);
                this.mergePage(array, page);
                pageDictionary.setItem(COSName.CONTENTS, (COSBase)array);
                continue;
            }
            if (contents instanceof COSArray) {
                COSArray contentsArray = (COSArray)contents;
                this.mergePage(contentsArray, page);
                continue;
            }
            throw new IOException("Contents are unknown type:" + contents.getClass().getName());
        }
    }

    private void mergePage(COSArray array, PDPage page) {
        int layoutPageNum = this.pageCount % this.layoutPages.size();
        LayoutPage layoutPage = (LayoutPage)this.layoutPages.get(layoutPageNum);
        PDResources resources = page.findResources();
        if (resources == null) {
            resources = new PDResources();
            page.setResources(resources);
        }
        COSDictionary docResDict = resources.getCOSDictionary();
        COSDictionary layoutResDict = layoutPage.res;
        this.mergeArray(PROC_SET, docResDict, layoutResDict);
        this.mergeDictionary(COSName.FONT, docResDict, layoutResDict, layoutPage.objectNameMap);
        this.mergeDictionary(XOBJECT, docResDict, layoutResDict, layoutPage.objectNameMap);
        this.mergeDictionary(EXT_G_STATE, docResDict, layoutResDict, layoutPage.objectNameMap);
        array.add(0, this.saveGraphicsStateStream);
        array.add(this.restoreGraphicsStateStream);
        array.add(layoutPage.contents);
    }

    private void mergeDictionary(COSName name, COSDictionary dest, COSDictionary source, Map objectNameMap) {
        COSDictionary destDict = (COSDictionary)dest.getDictionaryObject(name);
        COSDictionary sourceDict = (COSDictionary)source.getDictionaryObject(name);
        if (destDict == null) {
            destDict = new COSDictionary();
            dest.setItem(name, (COSBase)destDict);
        }
        if (sourceDict != null) {
            Iterator iterKeys = sourceDict.keyList().iterator();
            while (iterKeys.hasNext()) {
                COSName key = (COSName)iterKeys.next();
                COSName mappedKey = (COSName)objectNameMap.get(key.getName());
                if (mappedKey == null) continue;
                destDict.setItem(mappedKey, sourceDict.getItem(key));
            }
        }
    }

    private void mergeArray(COSName name, COSDictionary dest, COSDictionary source) {
        COSArray destDict = (COSArray)dest.getDictionaryObject(name);
        COSArray sourceDict = (COSArray)source.getDictionaryObject(name);
        if (destDict == null) {
            destDict = new COSArray();
            dest.setItem(name, (COSBase)destDict);
        }
        for (int sourceDictIdx = 0; sourceDict != null && sourceDictIdx < sourceDict.size(); ++sourceDictIdx) {
            COSBase key = sourceDict.get(sourceDictIdx);
            if (!(key instanceof COSName)) continue;
            COSName keyname = (COSName)key;
            boolean bFound = false;
            for (int destDictIdx = 0; destDictIdx < destDict.size(); ++destDictIdx) {
                COSName destkeyname;
                COSBase destkey = destDict.get(destDictIdx);
                if (!(destkey instanceof COSName) || !(destkeyname = (COSName)destkey).equals(keyname)) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            destDict.add(keyname);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LayoutPage {
        private final COSBase contents;
        private final COSDictionary res;
        private final Map objectNameMap;

        public LayoutPage(COSBase contentsValue, COSDictionary resValue, Map objectNameMapValue) {
            this.contents = contentsValue;
            this.res = resValue;
            this.objectNameMap = objectNameMapValue;
        }
    }
}

