/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeConfigurationOptionsResult
implements Serializable {
    private String solutionStackName;
    private ListWithAutoConstructFlag<ConfigurationOptionDescription> options;

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public DescribeConfigurationOptionsResult withSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
        return this;
    }

    public List<ConfigurationOptionDescription> getOptions() {
        if (this.options == null) {
            this.options = new ListWithAutoConstructFlag();
            this.options.setAutoConstruct(true);
        }
        return this.options;
    }

    public void setOptions(Collection<ConfigurationOptionDescription> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        ListWithAutoConstructFlag optionsCopy = new ListWithAutoConstructFlag(options.size());
        optionsCopy.addAll(options);
        this.options = optionsCopy;
    }

    public DescribeConfigurationOptionsResult withOptions(ConfigurationOptionDescription ... options) {
        if (this.getOptions() == null) {
            this.setOptions(new ArrayList<ConfigurationOptionDescription>(options.length));
        }
        for (ConfigurationOptionDescription value : options) {
            this.getOptions().add(value);
        }
        return this;
    }

    public DescribeConfigurationOptionsResult withOptions(Collection<ConfigurationOptionDescription> options) {
        if (options == null) {
            this.options = null;
        } else {
            ListWithAutoConstructFlag optionsCopy = new ListWithAutoConstructFlag(options.size());
            optionsCopy.addAll(options);
            this.options = optionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: " + this.getSolutionStackName() + ",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: " + this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsResult)) {
            return false;
        }
        DescribeConfigurationOptionsResult other = (DescribeConfigurationOptionsResult)obj;
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }
}

