/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;

public class ProxyCertInfoExtension
extends ASN1Object {
    public static final String RFC_EXTENSION_OID = "1.3.6.1.5.5.7.1.14";
    public static final String DRAFT_EXTENSION_OID = "1.3.6.1.4.1.3536.1.222";
    private int pathLen = Integer.MAX_VALUE;
    private ProxyPolicy policy;

    public ProxyCertInfoExtension(int pathLen, ProxyPolicy policy) {
        this.pathLen = pathLen;
        this.policy = policy;
    }

    public ProxyCertInfoExtension() {
        this.policy = new ProxyPolicy("1.3.6.1.5.5.7.21.1");
    }

    public ProxyCertInfoExtension(byte[] bytes) throws IOException {
        this((ASN1Sequence)ASN1Primitive.fromByteArray((byte[])bytes));
    }

    public ProxyCertInfoExtension(ASN1Sequence seq) throws IOException {
        int index = 0;
        if (seq == null || seq.size() == 0) {
            throw new IOException("ProxyCertInfoExtension is empty");
        }
        if (seq.getObjectAt(0) instanceof ASN1Integer) {
            this.pathLen = ((ASN1Integer)seq.getObjectAt(0)).getValue().intValue();
            index = 1;
        }
        if (seq.size() <= index) {
            throw new IOException("ProxyCertInfoExtension parser error, expected policy, but it was not found");
        }
        if (!(seq.getObjectAt(index) instanceof DLSequence)) {
            throw new IOException("ProxyCertInfoExtension parser error, expected policy sequence, but got: " + seq.getObjectAt(index).getClass());
        }
        this.policy = new ProxyPolicy((ASN1Sequence)((DLSequence)seq.getObjectAt(index)));
        if (seq.size() > ++index) {
            throw new IOException("ProxyCertInfoExtension parser error, sequence contains too many items");
        }
    }

    public static ProxyCertInfoExtension getInstance(X509Certificate cert) throws IOException {
        byte[] bytes = CertificateHelpers.getExtensionBytes(cert, RFC_EXTENSION_OID);
        if (bytes == null) {
            bytes = CertificateHelpers.getExtensionBytes(cert, DRAFT_EXTENSION_OID);
        }
        if (bytes == null) {
            return null;
        }
        return new ProxyCertInfoExtension(bytes);
    }

    public int getProxyPathLimit() {
        return this.pathLen;
    }

    public ProxyPolicy getPolicy() {
        return this.policy;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.pathLen != Integer.MAX_VALUE) {
            v.add((ASN1Encodable)new ASN1Integer((long)this.pathLen));
        }
        if (this.policy == null) {
            throw new IllegalArgumentException("Can't generate ProxyCertInfoExtension without mandatory policy");
        }
        v.add((ASN1Encodable)this.policy.toASN1Primitive());
        return new DLSequence(v);
    }
}

