/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.CachedElement;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.LazyEuGridPmaNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.LazyGlobusNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.NamespacesStore;
import eu.emi.security.authn.x509.helpers.trust.AbstractTrustAnchorStore;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.helpers.trust.TrustAnchorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.x500.X500Principal;

public class LazyOpensslTrustAnchorStoreImpl
extends AbstractTrustAnchorStore
implements OpensslTrustAnchorStore {
    public static final String CERTS_REGEXP = "........\\.[0-9]+";
    protected CachedElement<Set<TrustAnchorExt>> cachedAnchors;
    protected Map<X500Principal, CachedElement<Set<TrustAnchorExt>>> cachedAnchorsPerIssuer;
    private boolean openssl1Mode;
    private NamespacesStore pmaNsStore;
    private NamespacesStore globusNsStore;
    private File baseDirectory;

    public LazyOpensslTrustAnchorStoreImpl(String basePath, long updateInterval, ObserversHandler observers, boolean openssl1Mode) {
        super(updateInterval, observers);
        this.baseDirectory = new File(basePath);
        this.openssl1Mode = openssl1Mode;
        this.cachedAnchorsPerIssuer = new WeakHashMap<X500Principal, CachedElement<Set<TrustAnchorExt>>>(150);
        this.pmaNsStore = new LazyEuGridPmaNamespacesStore(observers, openssl1Mode, basePath, updateInterval);
        this.globusNsStore = new LazyGlobusNamespacesStore(observers, openssl1Mode, basePath, updateInterval);
    }

    protected X509Certificate tryLoadCertInternal(File file) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            X509Certificate cert = CertificateUtils.loadCertificate(is, CertificateUtils.Encoding.PEM);
            this.observers.notifyObservers(file.getAbsolutePath(), "CA Certificate", StoreUpdateListener.Severity.NOTIFICATION, null);
            return cert;
        }
        catch (Exception e) {
            this.observers.notifyObservers(file.getAbsolutePath(), "CA Certificate", StoreUpdateListener.Severity.ERROR, e);
            return null;
        }
    }

    protected void tryLoadCert(File file, Set<TrustAnchorExt> set) {
        String fileHash = OpensslTruststoreHelper.getFileHash(file.getPath(), "^([0-9a-fA-F]{8})\\.[\\d]+$");
        if (fileHash == null) {
            return;
        }
        X509Certificate cert = this.tryLoadCertInternal(file);
        if (cert == null) {
            return;
        }
        String certHash = OpensslTruststoreHelper.getOpenSSLCAHash(cert.getSubjectX500Principal(), this.openssl1Mode);
        if (!fileHash.equalsIgnoreCase(certHash)) {
            return;
        }
        TrustAnchorExt anchor = new TrustAnchorExt(cert, null);
        set.add(anchor);
    }

    @Override
    public NamespacesStore getPmaNsStore() {
        return this.pmaNsStore;
    }

    @Override
    public NamespacesStore getGlobusNsStore() {
        return this.globusNsStore;
    }

    private Set<TrustAnchorExt> loadTrustAnchors() {
        Collection<File> certs = OpensslTruststoreHelper.getFilesWithRegexp(CERTS_REGEXP, this.baseDirectory);
        HashSet<TrustAnchorExt> ret = new HashSet<TrustAnchorExt>(certs.size());
        for (File cert : certs) {
            this.tryLoadCert(cert, ret);
        }
        return ret;
    }

    @Override
    public Set<TrustAnchor> getTrustAnchors() {
        if (this.cachedAnchors == null || this.cachedAnchors.isExpired(this.getUpdateInterval())) {
            Set<TrustAnchorExt> loaded = this.loadTrustAnchors();
            this.cachedAnchors = new CachedElement<Set<TrustAnchorExt>>(loaded);
        }
        HashSet<TrustAnchor> ret = new HashSet<TrustAnchor>();
        ret.addAll((Collection)this.cachedAnchors.getElement());
        return ret;
    }

    @Override
    public X509Certificate[] getTrustedCertificates() {
        Set<TrustAnchor> anchors = this.getTrustAnchors();
        X509Certificate[] ret = new X509Certificate[anchors.size()];
        int i = 0;
        for (TrustAnchor ta : anchors) {
            ret[i++] = ta.getTrustedCert();
        }
        return ret;
    }

    @Override
    public void dispose() {
    }

    public Set<TrustAnchor> getTrustAnchorsFor(X509Certificate[] certChain) {
        HashSet<TrustAnchorExt> ret = new HashSet<TrustAnchorExt>();
        for (X509Certificate c : certChain) {
            this.tryLoadTAFor(c.getSubjectX500Principal(), ret);
        }
        this.tryLoadTAFor(certChain[certChain.length - 1].getIssuerX500Principal(), ret);
        return new HashSet<TrustAnchor>(ret);
    }

    private void tryLoadTAFor(X500Principal issuer, Set<TrustAnchorExt> ret) {
        CachedElement<Set<TrustAnchorExt>> cached = this.cachedAnchorsPerIssuer.get(issuer);
        if (cached != null && !cached.isExpired(this.updateInterval)) {
            ret.addAll((Collection<TrustAnchorExt>)cached.getElement());
            return;
        }
        HashSet<TrustAnchorExt> toCache = new HashSet<TrustAnchorExt>();
        String hash = OpensslTruststoreHelper.getOpenSSLCAHash(issuer, this.openssl1Mode);
        Collection<File> certs = OpensslTruststoreHelper.getFilesWithRegexp(hash + "\\.[0-9]+", this.baseDirectory);
        for (File file : certs) {
            X509Certificate cert = this.tryLoadCertInternal(file);
            if (!X500NameUtils.rfc3280Equal(cert.getSubjectX500Principal(), issuer)) continue;
            toCache.add(new TrustAnchorExt(cert, null));
            X500Principal certIssuer = cert.getIssuerX500Principal();
            if (X500NameUtils.rfc3280Equal(certIssuer, issuer)) continue;
            this.tryLoadTAFor(certIssuer, toCache);
        }
        ret.addAll(toCache);
        this.cachedAnchorsPerIssuer.put(issuer, new CachedElement(toCache));
    }
}

