/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal.permission.update;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.internal.permission.update.PermissionUpdater;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.user.core.tenant.Tenant;

public class PermissionUpdateTask
implements Runnable {
    private static final Log log = LogFactory.getLog(PermissionUpdateTask.class);
    private static ExecutorService threadPool = Executors.newCachedThreadPool();
    private String isRunning = "false";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = this.isRunning;
        synchronized (string) {
            if (this.isRunning.equals("true")) {
                return;
            }
        }
        this.isRunning = "true";
        if (log.isDebugEnabled()) {
            log.debug((Object)"Periodic task of updating permission cache is started.");
        }
        try {
            this.updateSuperTenantPermissions();
            this.updateTenantPermissions();
        }
        catch (Exception e) {
            log.error((Object)"Error when obtaining the tenant's govovernance registry instance to update the permission cache", (Throwable)e);
        }
        finally {
            this.isRunning = "false";
        }
    }

    private void updateSuperTenantPermissions() throws Exception {
        if (PermissionUpdater.needsUpdating(-1234)) {
            threadPool.submit(new TenantPermissionUpdateTask(-1234));
        }
    }

    private void updateTenantPermissions() throws Exception {
        Tenant[] tenants;
        ConfigurationContext mainServerConfigContext = CarbonCoreDataHolder.getInstance().getMainServerConfigContext();
        List<Tenant> tenantList = TenantAxisUtils.getActiveTenants(mainServerConfigContext);
        for (Tenant tenant : tenants = tenantList.toArray(new Tenant[tenantList.size()])) {
            int tenantId;
            if (!tenant.isActive() || !PermissionUpdater.needsUpdating(tenantId = tenant.getId())) continue;
            threadPool.submit(new TenantPermissionUpdateTask(tenantId));
        }
    }

    private static class TenantPermissionUpdateTask
    implements Runnable {
        private int tenantId;

        private TenantPermissionUpdateTask(int tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public void run() {
            PermissionUpdater.update(this.tenantId);
        }
    }
}

