/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.GSSContext;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.globus.common.CoGProperties;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSSContextX509
implements GSSContext {
    private org.ietf.jgss.GSSContext context = null;
    private GSSCredential credential;
    private static final Logger logger = LoggerFactory.getLogger(GSSContextX509.class);

    public void create(String user, String host) throws JSchException {
        try {
            if (this.credential == null) {
                try {
                    this.credential = this.getCredential();
                }
                catch (SecurityException t) {
                    System.out.printf("Could not get proxy: %s: %s\n", t.getClass().getSimpleName(), t.getMessage());
                    throw new JSchException(t.toString());
                }
            }
            String cname = host;
            try {
                cname = InetAddress.getByName(cname).getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            GSSName name = HostAuthorization.getInstance().getExpectedName(this.credential, cname);
            return;
        }
        catch (GSSException ex) {
            throw new JSchException(ex.toString());
        }
    }

    private static GSSCredential getProxy() {
        return GSSContextX509.getProxy(null, 0);
    }

    private static GSSCredential getProxy(String x509_USER_PROXY, int credentialLifetime) throws SecurityException {
        if (x509_USER_PROXY == null) {
            x509_USER_PROXY = System.getProperty("x509.user.proxy");
        }
        if (x509_USER_PROXY == null || "".equals(x509_USER_PROXY)) {
            x509_USER_PROXY = CoGProperties.getDefault().getProxyFile();
        }
        if (x509_USER_PROXY == null) {
            throw new SecurityException("could not get credential; no location defined");
        }
        ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        try {
            File f = new File(x509_USER_PROXY);
            byte[] data = new byte[(int)f.length()];
            FileInputStream in = new FileInputStream(f);
            in.read(data);
            in.close();
            return manager.createCredential(data, 0, credentialLifetime, null, 0);
        }
        catch (Throwable t) {
            throw new SecurityException("could not get credential from " + x509_USER_PROXY, t);
        }
    }

    public boolean isEstablished() {
        if (this.context != null) {
            return this.context.isEstablished();
        }
        return false;
    }

    public byte[] init(byte[] token, int s, int l) throws JSchException {
        try {
            if (this.context != null) {
                return this.context.initSecContext(token, s, l);
            }
            throw new JSchException("Context is null..");
        }
        catch (GSSException ex) {
            throw new JSchException(ex.toString());
        }
    }

    public byte[] getMIC(byte[] message, int s, int l) {
        try {
            MessageProp prop = new MessageProp(0, false);
            return this.context.getMIC(message, s, l, prop);
        }
        catch (GSSException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void dispose() {
        try {
            this.context.dispose();
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }

    public void setCredential(GSSCredential credential) {
        this.credential = credential;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }
}

