/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.GroovyMap;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.Script;
import org.apache.airavata.gfac.core.cluster.JobSubmissionOutput;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.JobSubmissionTask;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appdeployment.SetEnvPaths;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJobSubmissionTask
implements JobSubmissionTask {
    private static final Logger log = LoggerFactory.getLogger(LocalJobSubmissionTask.class);
    private ProcessBuilder builder;

    public void init(Map<String, String> propertyMap) throws TaskException {
    }

    public TaskStatus execute(TaskContext taskContext) {
        TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
        try {
            ProcessContext processContext = taskContext.getParentProcessContext();
            JobModel jobModel = processContext.getJobModel();
            jobModel.setTaskId(taskContext.getTaskId());
            RemoteCluster remoteCluster = processContext.getJobSubmissionRemoteCluster();
            GroovyMap groovyMap = GFacUtils.createGroovyMap((ProcessContext)processContext, (TaskContext)taskContext);
            String jobId = AiravataUtils.getId((String)"JOB_ID_");
            jobModel.setJobName(groovyMap.get(Script.JOB_NAME).toString());
            jobModel.setJobId(jobId);
            ResourceJobManager resourceJobManager = GFacUtils.getResourceJobManager((ProcessContext)processContext);
            JobManagerConfiguration jConfig = null;
            if (resourceJobManager != null) {
                jConfig = Factory.getJobManagerConfiguration(resourceJobManager);
            }
            JobStatus jobStatus = new JobStatus();
            File jobFile = GFacUtils.createJobFile((GroovyMap)groovyMap, (TaskContext)taskContext, (JobManagerConfiguration)jConfig);
            if (jobFile != null && jobFile.exists()) {
                jobModel.setJobDescription(FileUtils.readFileToString((File)jobFile));
                GFacUtils.saveJobModel((ProcessContext)processContext, (JobModel)jobModel);
                JobSubmissionOutput jobSubmissionOutput = remoteCluster.submitBatchJob(jobFile.getPath(), processContext.getWorkingDir());
                jobStatus.setJobState(JobState.SUBMITTED);
                jobStatus.setReason("Successfully Submitted to " + taskContext.getParentProcessContext().getComputeResourceDescription().getHostName());
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                jobModel.setJobStatuses(Arrays.asList(jobStatus));
                GFacUtils.saveJobStatus((ProcessContext)taskContext.getParentProcessContext(), (JobModel)jobModel);
                jobModel.setExitCode(jobSubmissionOutput.getExitCode());
                jobModel.setStdErr(jobSubmissionOutput.getStdErr());
                jobModel.setStdOut(jobSubmissionOutput.getStdOut());
                jobModel.setJobId(jobId);
                jobStatus.setJobState(JobState.COMPLETE);
                jobStatus.setReason("Successfully Completed " + taskContext.getParentProcessContext().getComputeResourceDescription().getHostName());
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                jobModel.setJobStatuses(Arrays.asList(jobStatus));
                GFacUtils.saveJobStatus((ProcessContext)taskContext.getParentProcessContext(), (JobModel)jobModel);
                taskStatus = new TaskStatus(TaskState.COMPLETED);
                taskStatus.setReason("Submitted job to compute resource");
            } else {
                taskStatus.setState(TaskState.FAILED);
                if (jobFile == null) {
                    taskStatus.setReason("JobFile is null");
                } else {
                    taskStatus.setReason("Job file doesn't exist");
                }
            }
        }
        catch (IOException | ApplicationSettingsException | GFacException | AppCatalogException e) {
            String msg = "Error occurred while submitting a local job";
            log.error(msg, e);
            taskStatus.setReason(msg);
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
            taskStatus.setState(TaskState.FAILED);
        }
        return taskStatus;
    }

    public TaskStatus recover(TaskContext taskContext) {
        return null;
    }

    private List<String> buildCommand(ProcessContext processContext) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(processContext.getApplicationDeploymentDescription().getExecutablePath());
        List processInputs = processContext.getProcessModel().getProcessInputs();
        Comparator<InputDataObjectType> inputOrderComparator = new Comparator<InputDataObjectType>(){

            @Override
            public int compare(InputDataObjectType inputDataObjectType, InputDataObjectType t1) {
                return inputDataObjectType.getInputOrder() - t1.getInputOrder();
            }
        };
        TreeSet<InputDataObjectType> sortedInputSet = new TreeSet<InputDataObjectType>(inputOrderComparator);
        for (InputDataObjectType input : processInputs) {
            sortedInputSet.add(input);
        }
        for (InputDataObjectType inputDataObjectType : sortedInputSet) {
            if (inputDataObjectType.getApplicationArgument() != null && !inputDataObjectType.getApplicationArgument().equals("")) {
                cmdList.add(inputDataObjectType.getApplicationArgument());
            }
            if (inputDataObjectType.getValue() == null || inputDataObjectType.getValue().equals("")) continue;
            cmdList.add(inputDataObjectType.getValue());
        }
        return cmdList;
    }

    private void initProcessBuilder(ApplicationDeploymentDescription app, List<String> cmdList) {
        this.builder = new ProcessBuilder(cmdList);
        List setEnvironment = app.getSetEnvironment();
        if (setEnvironment != null) {
            for (SetEnvPaths envPath : setEnvironment) {
                Map<String, String> builderEnv = this.builder.environment();
                builderEnv.put(envPath.getName(), envPath.getValue());
            }
        }
    }

    public TaskTypes getType() {
        return TaskTypes.JOB_SUBMISSION;
    }

    public JobStatus cancel(TaskContext taskcontext) {
        return null;
    }
}

