/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.impl.task.utils.bes.ApplicationProcessor;
import org.apache.airavata.gfac.impl.task.utils.bes.BESConstants;
import org.apache.airavata.gfac.impl.task.utils.bes.JSDLUtils;
import org.apache.airavata.gfac.impl.task.utils.bes.ResourceProcessor;
import org.apache.airavata.gfac.impl.task.utils.bes.UASDataStagingProcessor;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDLGenerator
implements BESConstants {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static synchronized JobDefinitionDocument buildJSDLInstance(ProcessContext context) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        JSDLGenerator.createJobIdentification(value, context);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        return jobDefDoc;
    }

    public static synchronized JobDefinitionDocument buildJSDLInstance(ProcessContext context, String smsUrl) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        JSDLGenerator.createJobIdentification(value, context);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        UASDataStagingProcessor.generateDataStagingElements(value, context, smsUrl);
        return jobDefDoc;
    }

    public static synchronized JobDefinitionDocument buildJSDLInstance(ProcessContext context, String smsUrl, Object jobDirectoryMode) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        JSDLGenerator.createJobIdentification(value, context);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        UASDataStagingProcessor.generateDataStagingElements(value, context, smsUrl);
        return jobDefDoc;
    }

    private static void createJobIdentification(JobDefinitionType value, ProcessContext context) {
        if (context != null) {
            if (context.getAllocationProjectNumber() != null) {
                JSDLUtils.addProjectName(value, context.getAllocationProjectNumber());
            }
            if (context.getApplicationInterfaceDescription() != null && context.getApplicationInterfaceDescription().getApplicationDescription() != null) {
                JSDLUtils.getOrCreateJobIdentification(value).setDescription(context.getApplicationInterfaceDescription().getApplicationDescription());
            }
            if (context.getApplicationInterfaceDescription() != null && context.getApplicationInterfaceDescription().getApplicationName() != null) {
                JSDLUtils.getOrCreateJobIdentification(value).setJobName(context.getApplicationInterfaceDescription().getApplicationName());
            }
        }
    }
}

