/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.client.CredentialStoreClientFactory;
import org.apache.airavata.credential.store.cpi.CredentialStoreService;
import org.apache.airavata.credential.store.exception.CredentialStoreException;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.credential.store.PasswordCredential;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.registry.api.RegistryService;
import org.apache.airavata.registry.api.client.RegistryServiceClientFactory;
import org.apache.airavata.registry.api.exception.RegistryServiceException;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.security.util.TrustStoreManager;
import org.apache.airavata.service.security.AiravataSecurityManager;
import org.apache.airavata.service.security.authzcache.AuthzCacheEntry;
import org.apache.airavata.service.security.authzcache.AuthzCacheIndex;
import org.apache.airavata.service.security.authzcache.AuthzCacheManager;
import org.apache.airavata.service.security.authzcache.AuthzCacheManagerFactory;
import org.apache.airavata.service.security.authzcache.AuthzCachedStatus;
import org.apache.airavata.service.security.oauth.DefaultOAuthClient;
import org.apache.airavata.service.security.xacml.DefaultPAPClient;
import org.apache.airavata.service.security.xacml.DefaultXACMLPEP;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;

public class DefaultAiravataSecurityManager
implements AiravataSecurityManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAiravataSecurityManager.class);

    @Override
    public void initializeSecurityInfra() throws AiravataSecurityException {
        try {
            if (ServerSettings.isAPISecured()) {
                String line;
                ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
                TrustStoreManager trustStoreManager = new TrustStoreManager();
                trustStoreManager.initializeTrustStoreManager(ServerSettings.getTrustStorePath(), ServerSettings.getTrustStorePassword());
                List gwProfiles = this.getRegistryServiceClient().getAllGatewayResourceProfiles();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(ServerSettings.getAuthorizationPoliyName() + ".xml")));
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                String defaultXACMLPolicy = stringBuilder.toString();
                CredentialStoreService.Client csClient = this.getCredentialStoreServiceClient();
                for (GatewayResourceProfile gwrp : gwProfiles) {
                    if (gwrp.getIdentityServerPwdCredToken() != null && gwrp.getIdentityServerTenant() != null) {
                        PasswordCredential credential = csClient.getPasswordCredential(gwrp.getIdentityServerPwdCredToken(), gwrp.getGatewayID());
                        String username = credential.getLoginUserName();
                        if (gwrp.getIdentityServerTenant() != null && !gwrp.getIdentityServerTenant().isEmpty()) {
                            username = username + "@" + gwrp.getIdentityServerTenant();
                        }
                        String password = credential.getPassword();
                        DefaultPAPClient PAPClient = new DefaultPAPClient(ServerSettings.getRemoteAuthzServerUrl(), username, password, configContext);
                        boolean policyAdded = PAPClient.isPolicyAdded(ServerSettings.getAuthorizationPoliyName());
                        if (policyAdded) {
                            logger.debug("Authorization policy is already added in the authorization server.");
                            continue;
                        }
                        PAPClient.addPolicy(defaultXACMLPolicy);
                        logger.debug("Authorization policy is published in the authorization server.");
                        continue;
                    }
                    logger.warn("Identity Server configuration missing for gateway : " + gwrp.getGatewayID());
                }
            }
        }
        catch (AxisFault axisFault) {
            logger.error(axisFault.getMessage(), (Throwable)axisFault);
            throw new AiravataSecurityException("Error in initializing the configuration context for creating the PAP client.");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in reading configuration when creating the PAP client.");
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in reading authorization policy.");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in reading the authorization policy.");
        }
        catch (RegistryServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in reading the Gateway Profiles from App Catalog.");
        }
        catch (TException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in connecting to Credential Store Service.");
        }
    }

    @Override
    public boolean isUserAuthorized(AuthzToken authzToken, Map<String, String> metaData) throws AiravataSecurityException {
        try {
            String subject = (String)authzToken.getClaimsMap().get("userName");
            String accessToken = authzToken.getAccessToken();
            String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
            String action = metaData.get("api.method.name");
            if (ServerSettings.isAuthzCacheEnabled()) {
                AuthzCacheManager authzCacheManager = AuthzCacheManagerFactory.getAuthzCacheManager();
                AuthzCachedStatus authzCachedStatus = authzCacheManager.getAuthzCachedStatus(new AuthzCacheIndex(subject, gatewayId, accessToken, action));
                if (AuthzCachedStatus.AUTHORIZED.equals((Object)authzCachedStatus)) {
                    logger.debug("Authz decision for: (" + subject + ", " + accessToken + ", " + action + ") is retrieved from cache.");
                    return true;
                }
                if (AuthzCachedStatus.NOT_AUTHORIZED.equals((Object)authzCachedStatus)) {
                    logger.debug("Authz decision for: (" + subject + ", " + accessToken + ", " + action + ") is retrieved from cache.");
                    return false;
                }
                if (AuthzCachedStatus.NOT_CACHED.equals((Object)authzCachedStatus)) {
                    logger.debug("Authz decision for: (" + subject + ", " + accessToken + ", " + action + ") is not in the cache. Obtaining it from the authorization server.");
                    CredentialStoreService.Client csClient = this.getCredentialStoreServiceClient();
                    GatewayResourceProfile gwrp = this.getRegistryServiceClient().getGatewayResourceProfile(gatewayId);
                    PasswordCredential credential = csClient.getPasswordCredential(gwrp.getIdentityServerPwdCredToken(), gwrp.getGatewayID());
                    String username = credential.getLoginUserName();
                    if (gwrp.getIdentityServerTenant() != null && !gwrp.getIdentityServerTenant().isEmpty()) {
                        username = username + "@" + gwrp.getIdentityServerTenant();
                    }
                    String password = credential.getPassword();
                    ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
                    TrustStoreManager trustStoreManager = new TrustStoreManager();
                    trustStoreManager.initializeTrustStoreManager(ServerSettings.getTrustStorePath(), ServerSettings.getTrustStorePassword());
                    DefaultOAuthClient oauthClient = new DefaultOAuthClient(ServerSettings.getRemoteAuthzServerUrl(), username, password, configContext);
                    OAuth2TokenValidationResponseDTO validationResponse = oauthClient.validateAccessToken(authzToken.getAccessToken());
                    if (validationResponse.getValid()) {
                        String authorizedUserName = validationResponse.getAuthorizedUser();
                        if (authorizedUserName.contains("@")) {
                            authorizedUserName = authorizedUserName.split("@")[0];
                        }
                        if (subject.contains("@")) {
                            subject = subject.split("@")[0];
                        }
                        if (!authorizedUserName.toLowerCase().equals(subject.toLowerCase())) {
                            return false;
                        }
                        long expiryTimestamp = validationResponse.getExpiryTime();
                        DefaultXACMLPEP entitlementClient = new DefaultXACMLPEP(ServerSettings.getRemoteAuthzServerUrl(), username, password, configContext);
                        boolean authorizationDecision = entitlementClient.getAuthorizationDecision(authzToken, metaData);
                        authzCacheManager.addToAuthzCache(new AuthzCacheIndex(subject, gatewayId, accessToken, action), new AuthzCacheEntry(authorizationDecision, expiryTimestamp, System.currentTimeMillis()));
                        return authorizationDecision;
                    }
                    return false;
                }
                throw new AiravataSecurityException("Error in reading from the authorization cache.");
            }
            CredentialStoreService.Client csClient = this.getCredentialStoreServiceClient();
            GatewayResourceProfile gwrp = this.getRegistryServiceClient().getGatewayResourceProfile(gatewayId);
            PasswordCredential credential = csClient.getPasswordCredential(gwrp.getIdentityServerPwdCredToken(), gwrp.getGatewayID());
            String username = credential.getLoginUserName();
            if (gwrp.getIdentityServerTenant() != null && !gwrp.getIdentityServerTenant().isEmpty()) {
                username = username + "@" + gwrp.getIdentityServerTenant();
            }
            String password = credential.getPassword();
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            TrustStoreManager trustStoreManager = new TrustStoreManager();
            trustStoreManager.initializeTrustStoreManager(ServerSettings.getTrustStorePath(), ServerSettings.getTrustStorePassword());
            DefaultOAuthClient oauthClient = new DefaultOAuthClient(ServerSettings.getRemoteAuthzServerUrl(), username, password, configContext);
            OAuth2TokenValidationResponseDTO validationResponse = oauthClient.validateAccessToken(authzToken.getAccessToken());
            boolean isOAuthTokenValid = validationResponse.getValid();
            DefaultXACMLPEP entitlementClient = new DefaultXACMLPEP(ServerSettings.getRemoteAuthzServerUrl(), username, password, configContext);
            boolean authorizationDecision = entitlementClient.getAuthorizationDecision(authzToken, metaData);
            return isOAuthTokenValid && authorizationDecision;
        }
        catch (AxisFault axisFault) {
            logger.error(axisFault.getMessage(), (Throwable)axisFault);
            throw new AiravataSecurityException("Error in initializing the configuration context for creating the OAuth validation client.");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in reading OAuth server configuration.");
        }
        catch (RegistryServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in accessing AppCatalog.");
        }
        catch (TException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in connecting to Credential Store Service.");
        }
    }

    private CredentialStoreService.Client getCredentialStoreServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getCredentialStoreServerPort());
        String serverHost = ServerSettings.getCredentialStoreServerHost();
        try {
            return CredentialStoreClientFactory.createAiravataCSClient((String)serverHost, (int)serverPort);
        }
        catch (CredentialStoreException e) {
            throw new TException("Unable to create credential store client...", (Throwable)e);
        }
    }

    private RegistryService.Client getRegistryServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getRegistryServerPort());
        String serverHost = ServerSettings.getRegistryServerHost();
        try {
            return RegistryServiceClientFactory.createRegistryClient((String)serverHost, (int)serverPort);
        }
        catch (RegistryServiceException e) {
            throw new TException("Unable to create registry client...", (Throwable)e);
        }
    }
}

