/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.ssl;

public class SSLKeystoreConfiguration {
    public static final String JAVA_DEFAULT_KEYSTORE_PATH = System.getProperty("java.home") + "/lib/security/cacerts";
    public static final String JAVA_DEFAULT_KEYSTORE_PASSWORD = "changeit";
    public static final String JAVA_DEFAULT_KEYSTORE_TYPE = "jks";
    boolean useDefaultJavaKeyStore = true;
    String keystore;
    String keystoreType = "jks";
    String keystorePassword;
    String keyManagerFactory = "SunX509";
    char[] pwd;

    public boolean isUseDefaultJavaKeyStore() {
        return this.useDefaultJavaKeyStore;
    }

    public void setUseDefaultJavaKeyStore(boolean useDefaultJavaKeyStore) {
        this.useDefaultJavaKeyStore = useDefaultJavaKeyStore;
    }

    public void setKeyManagerFactory(String keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeystorePassword() {
        if (this.keystorePassword == null && this.isUseDefaultJavaKeyStore()) {
            this.keystorePassword = JAVA_DEFAULT_KEYSTORE_PASSWORD;
        }
        return this.keystorePassword;
    }

    public String getKeystoreType() {
        if (this.keystoreType == null && this.isUseDefaultJavaKeyStore()) {
            this.keystoreType = JAVA_DEFAULT_KEYSTORE_TYPE;
        }
        return this.keystoreType;
    }

    public char[] getKeystorePasswordChars() {
        if (this.pwd == null) {
            this.pwd = this.getKeystorePassword().toCharArray();
        }
        return this.pwd;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getKeystore() {
        if (this.keystore == null && this.isUseDefaultJavaKeyStore()) {
            this.keystore = JAVA_DEFAULT_KEYSTORE_PATH;
        }
        return this.keystore;
    }

    public String getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public String toString() {
        return this.getClass().getName() + "[keystore path=" + this.getKeystore() + ", pwd=" + this.getKeystorePassword() + ", type=" + this.getKeystoreType() + "]";
    }
}

