/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.io.Writable;

public class BlockRecoveryInfo
implements Writable {
    private Block block;
    private boolean wasRecoveredOnStartup;

    public BlockRecoveryInfo() {
        this.block = new Block();
        this.wasRecoveredOnStartup = false;
    }

    public BlockRecoveryInfo(Block block, boolean wasRecoveredOnStartup) {
        this.block = new Block(block);
        this.wasRecoveredOnStartup = wasRecoveredOnStartup;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.block.readFields(in);
        this.wasRecoveredOnStartup = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.block.write(out);
        out.writeBoolean(this.wasRecoveredOnStartup);
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean wasRecoveredOnStartup() {
        return this.wasRecoveredOnStartup;
    }

    public String toString() {
        return "BlockRecoveryInfo(block=" + this.block + " wasRecoveredOnStartup=" + this.wasRecoveredOnStartup + ")";
    }
}

