/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.tenant.core.repositories;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.GatewayApprovalStatus;
import org.apache.airavata.service.profile.commons.repositories.AbstractRepository;
import org.apache.airavata.service.profile.commons.tenant.entities.GatewayEntity;
import org.apache.airavata.service.profile.commons.utils.QueryConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantProfileRepository
extends AbstractRepository<Gateway, GatewayEntity, String> {
    private static final Logger logger = LoggerFactory.getLogger(TenantProfileRepository.class);

    public TenantProfileRepository(Class<Gateway> thriftGenericClass, Class<GatewayEntity> dbEntityGenericClass) {
        super(thriftGenericClass, dbEntityGenericClass);
    }

    public Gateway getGateway(String airavataInternalGatewayId) throws Exception {
        Gateway gateway = null;
        try {
            HashMap<String, String> queryParam = new HashMap<String, String>();
            queryParam.put(Gateway._Fields.AIRAVATA_INTERNAL_GATEWAY_ID.getFieldName(), airavataInternalGatewayId);
            List gatewayList = this.select(QueryConstants.FIND_GATEWAY_BY_INTERNAL_ID, 1, 0, queryParam);
            if (!gatewayList.isEmpty()) {
                gateway = (Gateway)gatewayList.get(0);
            }
        }
        catch (Exception ex) {
            logger.error("Error while getting gateway, reason: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return gateway;
    }

    public List<Gateway> getAllGateways() throws Exception {
        try {
            List gatewayList = this.select("SELECT g FROM GatewayEntity g");
            return gatewayList;
        }
        catch (Exception e) {
            logger.error("Error while getting all the gateways, reason: ", (Throwable)e);
            throw e;
        }
    }

    public List<Gateway> getAllGatewaysForUser(String requesterUsername) throws Exception {
        try {
            HashMap<String, String> queryParam = new HashMap<String, String>();
            queryParam.put(Gateway._Fields.REQUESTER_USERNAME.getFieldName(), requesterUsername);
            List gatewayList = this.select(QueryConstants.GET_USER_GATEWAYS, queryParam);
            return gatewayList;
        }
        catch (Exception e) {
            logger.error("Error while getting the user's gateways, reason: ", (Throwable)e);
            throw e;
        }
    }

    public Gateway getDuplicateGateway(String gatewayId, String gatewayName, String gatewayURL) throws Exception {
        Gateway gateway = null;
        try {
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put(Gateway._Fields.GATEWAY_ID.getFieldName(), gatewayId);
            queryParams.put(Gateway._Fields.GATEWAY_NAME.getFieldName(), gatewayName);
            queryParams.put(Gateway._Fields.GATEWAY_URL.getFieldName(), gatewayURL);
            queryParams.put(Gateway._Fields.GATEWAY_APPROVAL_STATUS.getFieldName(), Arrays.asList(GatewayApprovalStatus.APPROVED.name(), GatewayApprovalStatus.CREATED.name(), GatewayApprovalStatus.DEPLOYED.name()));
            List gatewayList = this.select(QueryConstants.FIND_DUPLICATE_GATEWAY, 1, 0, queryParams);
            if (!gatewayList.isEmpty()) {
                gateway = (Gateway)gatewayList.get(0);
            }
        }
        catch (Exception ex) {
            logger.error("Error while searching for duplicate gateway, reason: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return gateway;
    }
}

