/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class LocalQueueStatsImpl
implements LocalQueueStats {
    private int ownedItemCount;
    private int backupItemCount;
    private long minAge;
    private long maxAge;
    private long aveAge;
    private long creationTime;
    private AtomicLong numberOfOffers = new AtomicLong(0L);
    private AtomicLong numberOfRejectedOffers = new AtomicLong(0L);
    private AtomicLong numberOfPolls = new AtomicLong(0L);
    private AtomicLong numberOfEmptyPolls = new AtomicLong(0L);
    private AtomicLong numberOfOtherOperations = new AtomicLong(0L);
    private AtomicLong numberOfEvents = new AtomicLong(0L);

    public LocalQueueStatsImpl() {
        this.creationTime = Clock.currentTimeMillis();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.ownedItemCount);
        out.writeInt(this.backupItemCount);
        out.writeLong(this.minAge);
        out.writeLong(this.maxAge);
        out.writeLong(this.aveAge);
        out.writeLong(this.creationTime);
        out.writeLong(this.numberOfOffers.get());
        out.writeLong(this.numberOfPolls.get());
        out.writeLong(this.numberOfRejectedOffers.get());
        out.writeLong(this.numberOfEmptyPolls.get());
        out.writeLong(this.numberOfOtherOperations.get());
        out.writeLong(this.numberOfEvents.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.ownedItemCount = in.readInt();
        this.backupItemCount = in.readInt();
        this.minAge = in.readLong();
        this.maxAge = in.readLong();
        this.aveAge = in.readLong();
        this.creationTime = in.readLong();
        this.numberOfOffers.set(in.readLong());
        this.numberOfPolls.set(in.readLong());
        this.numberOfRejectedOffers.set(in.readLong());
        this.numberOfEmptyPolls.set(in.readLong());
        this.numberOfOtherOperations.set(in.readLong());
        this.numberOfEvents.set(in.readLong());
    }

    @Override
    public long getMinAge() {
        return this.minAge;
    }

    public void setMinAge(long minAge) {
        this.minAge = minAge;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public long getAvgAge() {
        return this.aveAge;
    }

    public void setAveAge(long aveAge) {
        this.aveAge = aveAge;
    }

    @Override
    public long getOwnedItemCount() {
        return this.ownedItemCount;
    }

    public void setOwnedItemCount(int ownedItemCount) {
        this.ownedItemCount = ownedItemCount;
    }

    @Override
    public long getBackupItemCount() {
        return this.backupItemCount;
    }

    public void setBackupItemCount(int backupItemCount) {
        this.backupItemCount = backupItemCount;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public long total() {
        return this.numberOfOffers.get() + this.numberOfPolls.get() + this.numberOfOtherOperations.get();
    }

    @Override
    public long getOfferOperationCount() {
        return this.numberOfOffers.get();
    }

    @Override
    public long getRejectedOfferOperationCount() {
        return this.numberOfRejectedOffers.get();
    }

    @Override
    public long getPollOperationCount() {
        return this.numberOfPolls.get();
    }

    @Override
    public long getEmptyPollOperationCount() {
        return this.numberOfEmptyPolls.get();
    }

    @Override
    public long getOtherOperationsCount() {
        return this.numberOfOtherOperations.get();
    }

    public void incrementOtherOperations() {
        this.numberOfOtherOperations.incrementAndGet();
    }

    public void incrementOffers() {
        this.numberOfOffers.incrementAndGet();
    }

    public void incrementRejectedOffers() {
        this.numberOfRejectedOffers.incrementAndGet();
    }

    public void incrementPolls() {
        this.numberOfPolls.incrementAndGet();
    }

    public void incrementEmptyPolls() {
        this.numberOfEmptyPolls.incrementAndGet();
    }

    public void incrementReceivedEvents() {
        this.numberOfEvents.incrementAndGet();
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents.get();
    }
}

