/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.marshallers;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.DateUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

public class CalendarSetToStringSetMarshaller
implements ArgumentMarshaller.StringSetAttributeMarshaller {
    private static final CalendarSetToStringSetMarshaller INSTANCE = new CalendarSetToStringSetMarshaller();

    public static CalendarSetToStringSetMarshaller instance() {
        return INSTANCE;
    }

    private CalendarSetToStringSetMarshaller() {
    }

    @Override
    public AttributeValue marshall(Object obj) {
        Set dates = (Set)obj;
        ArrayList<String> timestamps = new ArrayList<String>(dates.size());
        for (Calendar date : dates) {
            timestamps.add(DateUtils.formatISO8601Date((Date)date.getTime()));
        }
        return new AttributeValue().withSS(timestamps);
    }
}

