/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.util.EnumerationConverter;
import org.apache.bval.jsr303.util.IOUtils;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.AnnotationProxyBuilder;
import org.apache.bval.jsr303.xml.AnnotationType;
import org.apache.bval.jsr303.xml.BeanType;
import org.apache.bval.jsr303.xml.ClassType;
import org.apache.bval.jsr303.xml.ConstraintDefinitionType;
import org.apache.bval.jsr303.xml.ConstraintMappingsType;
import org.apache.bval.jsr303.xml.ConstraintType;
import org.apache.bval.jsr303.xml.ElementType;
import org.apache.bval.jsr303.xml.FieldType;
import org.apache.bval.jsr303.xml.GetterType;
import org.apache.bval.jsr303.xml.GroupSequenceType;
import org.apache.bval.jsr303.xml.GroupsType;
import org.apache.bval.jsr303.xml.MetaConstraint;
import org.apache.bval.jsr303.xml.PayloadType;
import org.apache.bval.jsr303.xml.ValidatedByType;
import org.apache.bval.jsr303.xml.ValidationParser;
import org.apache.bval.util.FieldAccess;
import org.apache.bval.util.MethodAccess;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationMappingParser {
    private static final String VALIDATION_MAPPING_XSD = "META-INF/validation-mapping-1.0.xsd";
    private static final String[] RESERVED_PARAMS = new String[]{"message", "groups", "payload"};
    private final Set<Class<?>> processedClasses;
    private final ApacheValidatorFactory factory;

    public ValidationMappingParser(ApacheValidatorFactory factory) {
        this.factory = factory;
        this.processedClasses = new HashSet();
    }

    public void processMappingConfig(Set<InputStream> xmlStreams) throws ValidationException {
        for (InputStream xmlStream : xmlStreams) {
            ConstraintMappingsType mapping = this.parseXmlMappings(xmlStream);
            String defaultPackage = mapping.getDefaultPackage();
            this.processConstraintDefinitions(mapping.getConstraintDefinition(), defaultPackage);
            for (BeanType bean : mapping.getBean()) {
                Class<?> beanClass = this.loadClass(bean.getClazz(), defaultPackage);
                if (!this.processedClasses.add(beanClass)) {
                    throw new ValidationException(beanClass.getName() + " has already be configured in xml.");
                }
                this.factory.getAnnotationIgnores().setDefaultIgnoreAnnotation(beanClass, bean.isIgnoreAnnotations());
                this.processClassLevel(bean.getClassType(), beanClass, defaultPackage);
                this.processFieldLevel(bean.getField(), beanClass, defaultPackage);
                this.processPropertyLevel(bean.getGetter(), beanClass, defaultPackage);
                this.processedClasses.add(beanClass);
            }
        }
    }

    private ConstraintMappingsType parseXmlMappings(InputStream in) {
        ConstraintMappingsType mappings;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ConstraintMappingsType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(this.getSchema());
            StreamSource stream = new StreamSource(in);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ConstraintMappingsType.class);
            mappings = (ConstraintMappingsType)root.getValue();
        }
        catch (JAXBException e) {
            throw new ValidationException("Failed to parse XML deployment descriptor file.", e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return mappings;
    }

    private Schema getSchema() {
        return ValidationParser.getSchema(VALIDATION_MAPPING_XSD);
    }

    private void processClassLevel(ClassType classType, Class<?> beanClass, String defaultPackage) {
        Class<?>[] groupSequence;
        if (classType == null) {
            return;
        }
        if (classType.isIgnoreAnnotations() != null) {
            this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnClass(beanClass, classType.isIgnoreAnnotations());
        }
        if ((groupSequence = this.createGroupSequence(classType.getGroupSequence(), defaultPackage)) != null) {
            this.factory.addDefaultSequence(beanClass, groupSequence);
        }
        for (ConstraintType constraint : classType.getConstraint()) {
            MetaConstraint<?, ?> metaConstraint = this.createConstraint(constraint, beanClass, null, defaultPackage);
            this.factory.addMetaConstraint(beanClass, metaConstraint);
        }
    }

    private <A extends Annotation, T> MetaConstraint<?, ?> createConstraint(ConstraintType constraint, Class<T> beanClass, Member member, String defaultPackage) {
        Class<?> annotationClass = this.loadClass(constraint.getAnnotation(), defaultPackage);
        AnnotationProxyBuilder annoBuilder = new AnnotationProxyBuilder(annotationClass);
        if (constraint.getMessage() != null) {
            annoBuilder.setMessage(constraint.getMessage());
        }
        annoBuilder.setGroups(this.getGroups(constraint.getGroups(), defaultPackage));
        annoBuilder.setPayload(this.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            this.checkValidName(name);
            Class<?> returnType = this.getAnnotationParameterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType, defaultPackage);
            annoBuilder.putValue(name, elementValue);
        }
        return new MetaConstraint(beanClass, member, annoBuilder.createAnnotation());
    }

    private void checkValidName(String name) {
        for (String each : RESERVED_PARAMS) {
            if (!each.equals(name)) continue;
            throw new ValidationException(each + " is a reserved parameter name.");
        }
    }

    private <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m = SecureActions.getMethod(annotationClass, name);
        if (m == null) {
            throw new ValidationException("Annotation of type " + annotationClass.getName() + " does not contain a parameter " + name + ".");
        }
        return m.getReturnType();
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType, String defaultPackage) {
        this.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw new ValidationException("Attempt to specify an array where single value is expected.");
            }
            return this.getSingleValue(elementType.getContent().get(0), returnType, defaultPackage);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Serializable s : elementType.getContent()) {
            values.add(this.getSingleValue(s, returnType.getComponentType(), defaultPackage));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private void removeEmptyContentElements(ElementType elementType) {
        ArrayList<Serializable> contentToDelete = new ArrayList<Serializable>();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType, String defaultPackage) {
        Object returnValue;
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            returnValue = this.convertToResultType(returnType, value, defaultPackage);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(String.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            String value = (String)elem.getValue();
            returnValue = this.convertToResultType(returnType, value, defaultPackage);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            AnnotationType annotationType = (AnnotationType)elem.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = this.createAnnotation(annotationType, annotationClass, defaultPackage);
            }
            catch (ClassCastException e) {
                throw new ValidationException("Unexpected parameter value");
            }
        } else {
            throw new ValidationException("Unexpected parameter value");
        }
        return returnValue;
    }

    private Object convertToResultType(Class<?> returnType, String value, String defaultPackage) {
        Converter converter;
        if (returnType.equals(Class.class)) {
            value = this.toQualifiedClassName(value, defaultPackage);
        }
        if ((converter = ConvertUtils.lookup(returnType)) == null && returnType.isEnum()) {
            converter = EnumerationConverter.getInstance();
        }
        if (converter != null) {
            return converter.convert(returnType, value);
        }
        return converter;
    }

    private <A extends Annotation> Annotation createAnnotation(AnnotationType annotationType, Class<A> returnType, String defaultPackage) {
        AnnotationProxyBuilder<Class<A>> metaAnnotation = new AnnotationProxyBuilder<Class<A>>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = this.getAnnotationParameterType(returnType, name);
            Object elementValue = this.getElementValue(elementType, parameterType, defaultPackage);
            metaAnnotation.putValue(name, elementValue);
        }
        return metaAnnotation.createAnnotation();
    }

    private Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return new Class[0];
        }
        ArrayList groupList = new ArrayList();
        for (JAXBElement<String> groupClass : groupsType.getValue()) {
            groupList.add(this.loadClass((String)groupClass.getValue(), defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return new Class[0];
        }
        ArrayList payloadList = new ArrayList();
        for (JAXBElement<String> groupClass : payloadType.getValue()) {
            Class<?> payload = this.loadClass((String)groupClass.getValue(), defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw new ValidationException("Specified payload class " + payload.getName() + " does not implement javax.validation.Payload");
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }

    private Class<?>[] createGroupSequence(GroupSequenceType groupSequenceType, String defaultPackage) {
        if (groupSequenceType != null) {
            Class[] groupSequence = new Class[groupSequenceType.getValue().size()];
            int i = 0;
            for (JAXBElement<String> groupName : groupSequenceType.getValue()) {
                Class<?> group = this.loadClass((String)groupName.getValue(), defaultPackage);
                groupSequence[i++] = group;
            }
            return groupSequence;
        }
        return null;
    }

    private void processFieldLevel(List<FieldType> fields, Class<?> beanClass, String defaultPackage) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldType fieldType : fields) {
            boolean ignoreFieldAnnotation;
            String fieldName = fieldType.getName();
            if (fieldNames.contains(fieldName)) {
                throw new ValidationException(fieldName + " is defined more than once in mapping xml for bean " + beanClass.getName());
            }
            fieldNames.add(fieldName);
            Field field = SecureActions.getDeclaredField(beanClass, fieldName);
            if (field == null) {
                throw new ValidationException(beanClass.getName() + " does not contain the fieldType  " + fieldName);
            }
            boolean bl = ignoreFieldAnnotation = fieldType.isIgnoreAnnotations() == null ? false : fieldType.isIgnoreAnnotations();
            if (ignoreFieldAnnotation) {
                this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnMember(field);
            }
            if (fieldType.getValid() != null) {
                this.factory.addValid(beanClass, new FieldAccess(field));
            }
            for (ConstraintType constraintType : fieldType.getConstraint()) {
                MetaConstraint<?, ?> constraint = this.createConstraint(constraintType, beanClass, field, defaultPackage);
                this.factory.addMetaConstraint(beanClass, constraint);
            }
        }
    }

    private void processPropertyLevel(List<GetterType> getters, Class<?> beanClass, String defaultPackage) {
        ArrayList<String> getterNames = new ArrayList<String>();
        for (GetterType getterType : getters) {
            boolean ignoreGetterAnnotation;
            String getterName = getterType.getName();
            if (getterNames.contains(getterName)) {
                throw new ValidationException(getterName + " is defined more than once in mapping xml for bean " + beanClass.getName());
            }
            getterNames.add(getterName);
            Method method = SecureActions.getGetter(beanClass, getterName);
            if (method == null) {
                throw new ValidationException(beanClass.getName() + " does not contain the property  " + getterName);
            }
            boolean bl = ignoreGetterAnnotation = getterType.isIgnoreAnnotations() == null ? false : getterType.isIgnoreAnnotations();
            if (ignoreGetterAnnotation) {
                this.factory.getAnnotationIgnores().setIgnoreAnnotationsOnMember(method);
            }
            if (getterType.getValid() != null) {
                this.factory.addValid(beanClass, new MethodAccess(getterName, method));
            }
            for (ConstraintType constraintType : getterType.getConstraint()) {
                MetaConstraint<?, ?> metaConstraint = this.createConstraint(constraintType, beanClass, method, defaultPackage);
                this.factory.addMetaConstraint(beanClass, metaConstraint);
            }
        }
    }

    private void processConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList, String defaultPackage) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            Class<?> clazz = this.loadClass(annotationClassName, defaultPackage);
            if (!clazz.isAnnotation()) {
                throw new ValidationException(annotationClassName + " is not an annotation");
            }
            Class<?> annotationClass = clazz;
            ValidatedByType validatedByType = constraintDefinition.getValidatedBy();
            ArrayList classes = new ArrayList();
            if (validatedByType.isIncludeExistingValidators() != null && validatedByType.isIncludeExistingValidators().booleanValue()) {
                classes.addAll(this.findConstraintValidatorClasses(annotationClass));
            }
            for (JAXBElement<String> validatorClassName : validatedByType.getValue()) {
                Class<?> validatorClass = SecureActions.loadClass((String)validatorClassName.getValue(), this.getClass());
                if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                    throw new ValidationException(validatorClass + " is not a constraint validator class");
                }
                if (classes.contains(validatorClass)) continue;
                classes.add(validatorClass);
            }
            if (this.factory.getConstraintsCache().containsConstraintValidator(annotationClass)) {
                throw new ValidationException("Constraint validator for " + annotationClass.getName() + " already configured.");
            }
            this.factory.getConstraintsCache().putConstraintValidator(annotationClass, classes.toArray(new Class[classes.size()]));
        }
    }

    private List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> findConstraintValidatorClasses(Class<? extends Annotation> annotationType) {
        ArrayList classes = new ArrayList();
        Class<ConstraintValidator<? extends Annotation, ?>>[] validator = this.factory.getDefaultConstraints().getValidatorClasses(annotationType);
        if (validator != null) {
            classes.addAll(Arrays.asList(validator));
        } else {
            Class<? extends ConstraintValidator<?, ?>>[] validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
            classes.addAll(Arrays.asList(validatedBy));
        }
        return classes;
    }

    private Class<?> loadClass(String className, String defaultPackage) {
        return SecureActions.loadClass(this.toQualifiedClassName(className, defaultPackage), this.getClass());
    }

    private String toQualifiedClassName(String className, String defaultPackage) {
        if (!this.isQualifiedClass(className)) {
            className = defaultPackage + "." + className;
        }
        return className;
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.contains(".");
    }
}

