/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.samples;

import java.util.ArrayList;
import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.client.AiravataClientFactory;
import org.apache.airavata.client.samples.CreateLaunchExperiment;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.airavata.model.error.ExperimentNotFoundException;
import org.apache.airavata.model.error.InvalidRequestException;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.util.ExperimentModelUtil;
import org.apache.airavata.model.util.ProjectModelUtil;
import org.apache.airavata.model.workspace.Project;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLaunchExperimentUS3 {
    public static final String THRIFT_SERVER_HOST = "localhost";
    public static final int THRIFT_SERVER_PORT = 8930;
    private static final Logger logger = LoggerFactory.getLogger(CreateLaunchExperiment.class);
    private static final String DEFAULT_USER = "default.registry.user";
    private static final String DEFAULT_GATEWAY = "default.registry.gateway";

    public static void main(String[] args) {
        try {
            Airavata.Client airavata = AiravataClientFactory.createAiravataClient((String)THRIFT_SERVER_HOST, (int)8930);
            System.out.println("API version is " + airavata.getAPIVersion(null));
            String expId = CreateLaunchExperimentUS3.createUS3ExperimentForStampede(airavata);
            System.out.println("Experiment ID : " + expId);
            CreateLaunchExperimentUS3.launchExperiment(airavata, expId);
            System.out.println("Launched successfully");
        }
        catch (Exception e) {
            logger.error("Error while connecting with server", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static String createExperimentForTrestles(Airavata.Client client) throws TException {
        try {
            ArrayList<InputDataObjectType> exInputs = new ArrayList<InputDataObjectType>();
            InputDataObjectType input = new InputDataObjectType();
            input.setName("echo_input");
            input.setType(DataType.STRING);
            input.setValue("echo_output=Hello World");
            exInputs.add(input);
            ArrayList<OutputDataObjectType> exOut = new ArrayList<OutputDataObjectType>();
            OutputDataObjectType output = new OutputDataObjectType();
            output.setName("echo_output");
            output.setType(DataType.STRING);
            output.setValue("");
            exOut.add(output);
            Project project = ProjectModelUtil.createProject((String)"project1", (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"US3EchoExperimentTrestles", (String)"US3EchoTrestles", (String)"US3EchoTrestles", exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)"trestles.sdsc.edu", (int)1, (int)1, (int)1, (String)"shared", (int)0, (int)0);
            scheduling.setResourceHostId("gsissh-trestles");
            UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
            userConfigurationData.setAiravataAutoSchedule(false);
            userConfigurationData.setOverrideManualScheduledParams(false);
            userConfigurationData.setComputationalResourceScheduling(scheduling);
            simpleExperiment.setUserConfigurationData(userConfigurationData);
            return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static String createUS3ExperimentForTrestles(Airavata.Client client) throws AiravataSystemException, InvalidRequestException, AiravataClientException, TException {
        try {
            ArrayList<InputDataObjectType> exInputs = new ArrayList<InputDataObjectType>();
            InputDataObjectType input = new InputDataObjectType();
            input.setName("input");
            input.setType(DataType.URI);
            input.setValue("file:///home/sgg/chathuri/laptop_backup/airavata/ultrascan_input/hpcinput.tar");
            InputDataObjectType input1 = new InputDataObjectType();
            input1.setName("walltime");
            input1.setType(DataType.STRING);
            input1.setValue("-walltime=60");
            InputDataObjectType input2 = new InputDataObjectType();
            input2.setName("mgroupcount");
            input2.setType(DataType.STRING);
            input2.setValue("-mgroupcount=1");
            exInputs.add(input);
            exInputs.add(input1);
            exInputs.add(input2);
            ArrayList<OutputDataObjectType> exOut = new ArrayList<OutputDataObjectType>();
            OutputDataObjectType output = new OutputDataObjectType();
            output.setName("output");
            output.setType(DataType.URI);
            output.setValue("");
            exOut.add(output);
            Project project = ProjectModelUtil.createProject((String)"ultrascan", (String)"ultrascan", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"ultrascan", (String)"US3ExperimentTrestles", (String)"US3AppTrestles", (String)"ultrascan_7ce6cd43-622c-44e0-87c5-fb7a6528c799", exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)"trestles.sdsc.xsede.org_72b9181b-7156-4975-a386-ed98b4949496", (int)32, (int)1, (int)0, (String)"shared", (int)30, (int)0);
            UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
            scheduling.setResourceHostId("trestles.sdsc.xsede.org_72b9181b-7156-4975-a386-ed98b4949496");
            userConfigurationData.setAiravataAutoSchedule(false);
            userConfigurationData.setOverrideManualScheduledParams(false);
            userConfigurationData.setComputationalResourceScheduling(scheduling);
            simpleExperiment.setUserConfigurationData(userConfigurationData);
            return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static String createUS3ExperimentForStampede(Airavata.Client client) throws AiravataSystemException, InvalidRequestException, AiravataClientException, TException {
        try {
            ArrayList<InputDataObjectType> exInputs = new ArrayList<InputDataObjectType>();
            InputDataObjectType input = new InputDataObjectType();
            input.setName("input");
            input.setType(DataType.URI);
            input.setValue("file:///home/sgg/chathuri/laptop_backup/airavata/ultrascan_input/hpcinput.tar");
            InputDataObjectType input1 = new InputDataObjectType();
            input1.setName("walltime");
            input1.setType(DataType.STRING);
            input1.setValue("-walltime=60");
            InputDataObjectType input2 = new InputDataObjectType();
            input2.setName("mgroupcount");
            input2.setType(DataType.STRING);
            input2.setValue("-mgroupcount=1");
            exInputs.add(input);
            exInputs.add(input1);
            exInputs.add(input2);
            ArrayList<OutputDataObjectType> exOut = new ArrayList<OutputDataObjectType>();
            OutputDataObjectType output = new OutputDataObjectType();
            output.setName("output");
            output.setType(DataType.URI);
            output.setValue("");
            exOut.add(output);
            Project project = ProjectModelUtil.createProject((String)"project1", (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"ultrascan", (String)"US3ExperimentStampede", (String)"US3AppStampede", (String)"ultrascan_7ce6cd43-622c-44e0-87c5-fb7a6528c799", exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)"stampede.tacc.xsede.org_e59e046f-e0e1-49c4-8475-2fab2e35d044", (int)32, (int)2, (int)0, (String)"normal", (int)30, (int)0);
            scheduling.setResourceHostId("stampede.tacc.xsede.org_e59e046f-e0e1-49c4-8475-2fab2e35d044");
            UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
            userConfigurationData.setAiravataAutoSchedule(false);
            userConfigurationData.setOverrideManualScheduledParams(false);
            userConfigurationData.setComputationalResourceScheduling(scheduling);
            simpleExperiment.setUserConfigurationData(userConfigurationData);
            return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static String createUS3ExperimentForLonestar(Airavata.Client client) throws AiravataSystemException, InvalidRequestException, AiravataClientException, TException {
        try {
            ArrayList<InputDataObjectType> exInputs = new ArrayList<InputDataObjectType>();
            InputDataObjectType input = new InputDataObjectType();
            input.setName("input");
            input.setType(DataType.URI);
            input.setValue("file:///home/airavata/input/hpcinput.tar");
            InputDataObjectType input1 = new InputDataObjectType();
            input1.setName("walltime");
            input1.setType(DataType.STRING);
            input1.setValue("-walltime=60");
            InputDataObjectType input2 = new InputDataObjectType();
            input2.setName("mgroupcount");
            input2.setType(DataType.STRING);
            input2.setValue("-mgroupcount=1");
            exInputs.add(input);
            exInputs.add(input1);
            exInputs.add(input2);
            ArrayList<OutputDataObjectType> exOut = new ArrayList<OutputDataObjectType>();
            OutputDataObjectType output = new OutputDataObjectType();
            output.setName("output");
            output.setType(DataType.URI);
            output.setValue("");
            exOut.add(output);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)"ultrascan_41574ef5-b054-4d03-ab20-2cfe768d5096", (String)"ultrascan", (String)"US3ExperimentLonestar", (String)"US3AppLonestar", (String)"ultrascan_e76ab5cf-79f6-44df-a244-10a734183fec", exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)"lonestar.tacc.teragrid.org_2e0273bc-324b-419b-9786-38a360d44772", (int)12, (int)2, (int)0, (String)"normal", (int)30, (int)0);
            scheduling.setResourceHostId("lonestar.tacc.teragrid.org_2e0273bc-324b-419b-9786-38a360d44772");
            UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
            userConfigurationData.setAiravataAutoSchedule(false);
            userConfigurationData.setOverrideManualScheduledParams(false);
            userConfigurationData.setComputationalResourceScheduling(scheduling);
            simpleExperiment.setUserConfigurationData(userConfigurationData);
            return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static String createUS3ExperimentForAlamo(Airavata.Client client) throws AiravataSystemException, InvalidRequestException, AiravataClientException, TException {
        try {
            ArrayList<InputDataObjectType> exInputs = new ArrayList<InputDataObjectType>();
            InputDataObjectType input = new InputDataObjectType();
            input.setName("input");
            input.setType(DataType.URI);
            input.setValue("file:///home/airavata/input/hpcinput.tar");
            InputDataObjectType input1 = new InputDataObjectType();
            input1.setName("walltime");
            input1.setType(DataType.STRING);
            input1.setValue("-walltime=60");
            InputDataObjectType input2 = new InputDataObjectType();
            input2.setName("mgroupcount");
            input2.setType(DataType.STRING);
            input2.setValue("-mgroupcount=1");
            exInputs.add(input);
            exInputs.add(input1);
            exInputs.add(input2);
            ArrayList<OutputDataObjectType> exOut = new ArrayList<OutputDataObjectType>();
            OutputDataObjectType output = new OutputDataObjectType();
            output.setName("output");
            output.setType(DataType.URI);
            output.setValue("");
            exOut.add(output);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)"ultrascan_41574ef5-b054-4d03-ab20-2cfe768d5096", (String)"ultrascan", (String)"US3ExperimentStampede", (String)"US3AppStampede", (String)"ultrascan_e76ab5cf-79f6-44df-a244-10a734183fec", exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)"alamo.uthscsa.edu_7b6cf99a-af2e-4e8b-9eff-998a5ef60fe5", (int)4, (int)2, (int)0, (String)"default", (int)30, (int)0);
            scheduling.setResourceHostId("alamo.uthscsa.edu_7b6cf99a-af2e-4e8b-9eff-998a5ef60fe5");
            UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
            userConfigurationData.setAiravataAutoSchedule(false);
            userConfigurationData.setOverrideManualScheduledParams(false);
            userConfigurationData.setComputationalResourceScheduling(scheduling);
            simpleExperiment.setUserConfigurationData(userConfigurationData);
            return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static String createExperimentForStampede(Airavata.Client client) throws TException {
        try {
            ArrayList<InputDataObjectType> exInputs = new ArrayList<InputDataObjectType>();
            InputDataObjectType input = new InputDataObjectType();
            input.setName("echo_input");
            input.setType(DataType.STRING);
            input.setValue("echo_output=Hello World");
            exInputs.add(input);
            ArrayList<OutputDataObjectType> exOut = new ArrayList<OutputDataObjectType>();
            OutputDataObjectType output = new OutputDataObjectType();
            output.setName("echo_output");
            output.setType(DataType.STRING);
            output.setValue("");
            exOut.add(output);
            Project project = ProjectModelUtil.createProject((String)"project1", (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"US3EchoExperimentStatus", (String)"US3EchoStampede", (String)"US3EchoStampede", exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)"stampede.tacc.xsede.org", (int)1, (int)1, (int)1, (String)"development", (int)0, (int)0);
            scheduling.setResourceHostId("gsissh-stampede");
            UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
            userConfigurationData.setAiravataAutoSchedule(false);
            userConfigurationData.setOverrideManualScheduledParams(false);
            userConfigurationData.setComputationalResourceScheduling(scheduling);
            simpleExperiment.setUserConfigurationData(userConfigurationData);
            return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static void launchExperiment(Airavata.Client client, String expId) throws TException {
        try {
            client.launchExperiment(new AuthzToken(""), expId, DEFAULT_GATEWAY);
        }
        catch (ExperimentNotFoundException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new ExperimentNotFoundException(e);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }
}

