/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.SSLServer;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.commons.ssl.Util;

public class SSLEchoServer {
    public static void main(String[] args) throws Exception {
        int port = 7443;
        if (args.length >= 1) {
            port = Integer.parseInt(args[0]);
        }
        SSLServer ssl = new SSLServer();
        ssl.addTrustMaterial(TrustMaterial.TRUST_ALL);
        SSLServerSocket ss = (SSLServerSocket)ssl.createServerSocket(port, 3);
        System.out.println("SSL Echo server listening on port: " + port);
        while (true) {
            SSLSocket s = (SSLSocket)ss.accept();
            s.setSoTimeout(30000);
            EchoRunnable r = new EchoRunnable(s);
            new Thread(r).start();
        }
    }

    public static class EchoRunnable
    implements Runnable {
        private SSLSocket s;

        public EchoRunnable(SSLSocket s) {
            this.s = s;
        }

        public void run() {
            InputStream in = null;
            OutputStream out = null;
            System.out.println("Socket accepted!");
            try {
                SSLSession session = this.s.getSession();
                try {
                    Certificate[] certs = JavaImpl.getPeerCertificates(session);
                    if (certs != null) {
                        for (int i = 0; i < certs.length; ++i) {
                            X509Certificate cert = (X509Certificate)certs[i];
                            String s = "client cert " + i + ":";
                            s = s + JavaImpl.getSubjectX500(cert);
                            System.out.println(s);
                            System.out.println(Certificates.toString(cert));
                        }
                    }
                }
                catch (SSLPeerUnverifiedException sslpue) {
                    // empty catch block
                }
                in = this.s.getInputStream();
                out = this.s.getOutputStream();
                String line = Util.readLine(in);
                if (line != null && line.indexOf("HTTP") > 0) {
                    out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
                    out.flush();
                }
                while (line != null) {
                    String echo = "ECHO:>" + line + "\n";
                    out.write(echo.getBytes());
                    out.flush();
                    line = Util.readLine(in);
                }
            }
            catch (IOException ioe) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    this.s.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ioe instanceof InterruptedIOException) {
                    System.out.println("Socket closed after 30 second timeout.");
                }
                ioe.printStackTrace();
            }
        }
    }
}

