/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.log4j.Logger;

public class HttpBasicClient
implements FiletransferOptions.Read,
FiletransferOptions.Write,
FiletransferOptions.IMonitorable,
FiletransferOptions.SupportsPartialRead {
    private static final Logger logger = Log.getLogger("unicore.client", HttpBasicClient.class);
    private final String accessURL;
    private final IClientConfiguration sec;
    private Long totalBytesTransferred = 0L;
    private ProgressListener<Long> observer;
    private boolean append = false;

    public HttpBasicClient(String url, IClientConfiguration sec) throws Exception {
        this.accessURL = url;
        this.sec = sec;
    }

    @Override
    public void readAllData(OutputStream os) throws Exception {
        HttpClient client = this.getClient();
        HttpGet get = new HttpGet(this.accessURL);
        this.totalBytesTransferred = this.read(os, get, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long read(OutputStream os, HttpGet get, HttpClient client) throws IOException {
        InputStream is = null;
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            int result = response.getStatusLine().getStatusCode();
            if (result < 200 || result > 299) {
                String status = response.getStatusLine().toString();
                throw new IOException("Can't read remote data, server returned " + status);
            }
            is = response.getEntity().getContent();
            long l = this.copy(is, os);
            return l;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignored) {}
            get.releaseConnection();
        }
    }

    public void writeAllData(InputStream is, boolean append) throws Exception {
        this.append = append;
        this.writeAllData(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAllData(final InputStream is) throws Exception {
        HttpClient client = this.getClient();
        HttpEntityEnclosingRequestBase upload = this.createMethodForUpload();
        InputStream decoratedStream = new InputStream(){

            @Override
            public int read() throws IOException {
                int b = is.read();
                if (b != -1) {
                    Long l = HttpBasicClient.this.totalBytesTransferred;
                    Long l2 = HttpBasicClient.this.totalBytesTransferred = HttpBasicClient.this.totalBytesTransferred + 1L;
                    if (HttpBasicClient.this.observer != null) {
                        HttpBasicClient.this.observer.notifyProgress(1L);
                        if (HttpBasicClient.this.observer.isCancelled()) {
                            throw new ProgressListener.CancelledException("Cancelled.");
                        }
                    }
                }
                return b;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int r = is.read(b, off, len);
                if (r > 0) {
                    HttpBasicClient.this.totalBytesTransferred = HttpBasicClient.this.totalBytesTransferred + (long)r;
                    if (HttpBasicClient.this.observer != null) {
                        HttpBasicClient.this.observer.notifyProgress(Long.valueOf(r));
                        if (HttpBasicClient.this.observer.isCancelled()) {
                            throw new ProgressListener.CancelledException("Cancelled.");
                        }
                    }
                }
                return r;
            }
        };
        upload.setEntity((HttpEntity)new InputStreamEntity(decoratedStream, -1L));
        this.totalBytesTransferred = 0L;
        try {
            HttpResponse response = client.execute((HttpUriRequest)upload);
            int result = response.getStatusLine().getStatusCode();
            String status = response.getStatusLine().toString();
            if (result < 200 || result > 299) {
                throw new IOException("Can't write data, server returned " + status);
            }
            logger.debug("Total transferred bytes: " + this.totalBytesTransferred + ", HTTP return status " + status);
        }
        finally {
            upload.releaseConnection();
        }
    }

    @Override
    public void writeAllData(InputStream source, long numBytes) throws Exception {
        if (numBytes < 0L) {
            this.writeAllData(source);
        } else {
            this.writeAllData((InputStream)new BoundedInputStream(source, numBytes));
        }
    }

    public String getAccessURL() {
        return this.accessURL;
    }

    @Override
    public long readPartial(long offset, long length, OutputStream os) throws IOException {
        HttpClient client = this.getClient();
        HttpGet get = new HttpGet(this.accessURL);
        get.addHeader("Range", "bytes=" + offset + "-" + (offset + length - 1L));
        return this.read(os, get, client);
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 16384;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        int c = 0;
        long progress = 0L;
        long total = 0L;
        while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
            if (len <= 0) continue;
            out.write(buffer, 0, len);
            total += (long)len;
            progress += (long)len;
            if (++c % 10 != 0 || this.observer == null) continue;
            this.observer.notifyProgress(progress);
            if (this.observer.isCancelled()) {
                throw new ProgressListener.CancelledException("Cancelled.");
            }
            progress = 0L;
        }
        if (this.observer != null) {
            this.observer.notifyProgress(progress);
        }
        out.flush();
        return total;
    }

    protected HttpClient getClient() {
        HttpClient client = HttpUtils.createClient(this.accessURL, this.sec);
        return client;
    }

    public long getTotalBytesTransferred() {
        return this.totalBytesTransferred;
    }

    @Override
    public void setProgressListener(ProgressListener<Long> o) {
        this.observer = o;
    }

    protected HttpEntityEnclosingRequestBase createMethodForUpload() {
        return this.accessURL.contains("method=POST") ? this.createPost() : this.createPut();
    }

    protected HttpEntityEnclosingRequestBase createPut() {
        HttpPut upload = new HttpPut(this.accessURL);
        if (this.append) {
            upload.addHeader("X-UNICORE-AppendData", "true");
        }
        return upload;
    }

    protected HttpEntityEnclosingRequestBase createPost() {
        HttpPost upload = new HttpPost(this.accessURL);
        upload.addHeader("Content-Type", "multipart/form-data; boundary=--part-boundary--");
        if (this.append) {
            upload.addHeader("X-UNICORE-AppendData", "true");
        }
        return upload;
    }
}

