/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.etd;

import java.util.Calendar;
import java.util.Date;
import org.apache.xmlbeans.XmlObject;

public class DelegationRestrictions
implements Cloneable {
    private Date notBefore;
    private Date notOnOrAfter;
    private int maxProxyCount;
    private XmlObject[] conditions;

    public DelegationRestrictions(Date notBefore, Date notOnOrAfter, int maxProxyCount) {
        this.notBefore = notBefore;
        this.notOnOrAfter = notOnOrAfter;
        this.maxProxyCount = maxProxyCount;
    }

    public DelegationRestrictions(Date notBefore, int validDays, int maxProxyCount) {
        this.notBefore = notBefore;
        Calendar c = Calendar.getInstance();
        if (notBefore != null) {
            c.setTime(notBefore);
        }
        c.add(5, validDays);
        this.notOnOrAfter = c.getTime();
        this.maxProxyCount = maxProxyCount;
    }

    public int getMaxProxyCount() {
        return this.maxProxyCount;
    }

    public void setMaxProxyCount(int maxProxyCount) {
        this.maxProxyCount = maxProxyCount;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(Date notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter;
    }

    public XmlObject[] getCustomConditions() {
        return this.conditions;
    }

    public void setCustomConditions(XmlObject[] conditions) {
        this.conditions = conditions;
    }

    public DelegationRestrictions clone() {
        DelegationRestrictions clone = new DelegationRestrictions(this.notBefore == null ? null : new Date(this.notBefore.getTime()), this.notOnOrAfter == null ? null : new Date(this.notOnOrAfter.getTime()), this.maxProxyCount);
        if (this.conditions != null) {
            clone.setCustomConditions((XmlObject[])this.conditions.clone());
        }
        return clone;
    }
}

