/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.etd;

import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.DsigSamlTrustCheckerBase;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.w3.x2000.x09.xmldsig.SignatureType;

public class ETDSamlTrustChecker
extends DsigSamlTrustCheckerBase {
    protected X509CertChainValidator validator;
    protected X509Certificate[] expectedIssuer;

    public ETDSamlTrustChecker(X509CertChainValidator validator, X509Certificate[] expectedIssuer) {
        this.validator = validator;
        this.expectedIssuer = expectedIssuer;
    }

    @Override
    protected PublicKey establishKey(NameIDType issuer, SignatureType signature) throws SAMLValidationException {
        ValidationResult result = this.validator.validate(this.expectedIssuer);
        if (!result.isValid()) {
            throw new SAMLValidationException("Delegation signature was conducted by an untrusted entity: " + result.toShortString());
        }
        return this.expectedIssuer[0].getPublicKey();
    }
}

