/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SignatureStatus;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.DigSignatureUtil;
import eu.unicore.security.dsig.IdAttribute;
import eu.unicore.security.wsutil.AuthInHandler;
import eu.unicore.security.wsutil.DSigParseInHandler;
import eu.unicore.security.wsutil.client.ToBeSignedDecider;
import eu.unicore.util.Log;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.log4j.Logger;
import org.apache.ws.security.WSEncryptionPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSigSecurityInHandler
extends AbstractSoapInterceptor {
    private static Logger logger = Log.getLogger("unicore.security.dsig", DSigSecurityInHandler.class);
    private static final String WSS_NS_STRING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String XML_DS_STRING = "http://www.w3.org/2000/09/xmldsig#";
    public static final QName WS_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static final String WSSUTIL_NS_STRING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final IdAttribute WS_ID_ATTRIBUTE = new IdAttribute("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    private ToBeSignedDecider partsDecider;
    private static final Set<QName> qnameSet = new HashSet<QName>();

    public DSigSecurityInHandler(ToBeSignedDecider partsDecider) {
        super("pre-invoke");
        this.getAfter().add(DSigParseInHandler.class.getName());
        this.getAfter().add(AuthInHandler.class.getName());
        this.partsDecider = partsDecider;
    }

    public Set<QName> getUnderstoodHeaders() {
        return qnameSet;
    }

    public void handleMessage(SoapMessage message) {
        SecurityTokens securityTokens = (SecurityTokens)message.get((Object)SecurityTokens.KEY);
        if (securityTokens == null) {
            logger.error("No security context found. You should add " + AuthInHandler.class.getName() + " handler.");
            return;
        }
        securityTokens.setMessageSignatureStatus(SignatureStatus.UNCHECKED);
        Document doc = (Document)message.get((Object)DSigParseInHandler.DOCUMENT_DOM_KEY);
        if (doc == null) {
            logger.debug("No DOM representation of message found, signature won't be checked");
            return;
        }
        Header wssHeader = message.getHeader(WS_SECURITY);
        if (wssHeader == null) {
            logger.debug("No security header element found, skipping signature verification.");
            securityTokens.setMessageSignatureStatus(SignatureStatus.UNSIGNED);
            return;
        }
        Element secHeader = (Element)wssHeader.getObject();
        if (this.getChildElements(secHeader, XML_DS_STRING, "Signature").size() == 0) {
            logger.debug("No Signature was found in header, skipping signature verification.");
            securityTokens.setMessageSignatureStatus(SignatureStatus.UNSIGNED);
            return;
        }
        try {
            this.verify(securityTokens, doc, secHeader);
        }
        catch (Exception e) {
            logger.warn("Error while checking signature of request: " + e + "\n" + e.getCause());
            securityTokens.setMessageSignatureStatus(SignatureStatus.WRONG);
            return;
        }
    }

    protected void verify(SecurityTokens securityTokens, Document doc, Element secHeader) throws Exception {
        boolean signedOK;
        long start = System.currentTimeMillis();
        X509Certificate[] consignorCC = securityTokens.getConsignor();
        if (consignorCC == null || consignorCC.length == 0) {
            logger.debug("No consignor found in security context so skipping signature verification.");
            return;
        }
        X509Certificate consignorCert = consignorCC[0];
        PublicKey consignorsKey = consignorCert.getPublicKey();
        long preVerify = System.currentTimeMillis();
        try {
            logger.trace("Starting signature verification");
            signedOK = this.verifySignature(doc, consignorsKey);
        }
        catch (Exception e) {
            logger.warn("Error while checking signature of request: " + e + "\n" + e.getCause());
            securityTokens.setMessageSignatureStatus(SignatureStatus.WRONG);
            return;
        }
        if (signedOK) {
            logger.debug("Signature present and CORRECT");
            securityTokens.setMessageSignatureStatus(SignatureStatus.OK);
        } else {
            logger.warn("Signature present but INCORRECT!!");
            securityTokens.setMessageSignatureStatus(SignatureStatus.WRONG);
        }
        long end = System.currentTimeMillis();
        logger.debug("Total time: " + (end - start) + " where actual verification was: " + (end - preVerify));
    }

    private boolean verifySignature(Document signedDocument, PublicKey validatingKey) throws DSigException {
        NodeList nl = signedDocument.getElementsByTagNameNS(WSS_NS_STRING, "Security");
        if (nl.getLength() == 0) {
            throw new DSigException("Document not signed");
        }
        if (nl.getLength() > 1) {
            throw new DSigException("Document contains more then one wss:Security element. This is not supported and may indicate an attack on XML digital signature.");
        }
        Element securityElement = (Element)nl.item(0);
        List<Element> signatures = this.getChildElements(securityElement, XML_DS_STRING, "Signature");
        if (signatures.size() == 0) {
            throw new DSigException("Document not signed");
        }
        if (signatures.size() > 1) {
            throw new DSigException("Document's wss:Security element contains more then one dsig:Signature element. This is not supported and may indicate an attack on XML digital signature.");
        }
        DigSignatureUtil dsigEngine = new DigSignatureUtil();
        Node signatureNode = signatures.get(0);
        List<Element> required = this.getRequiredElements(signedDocument);
        return dsigEngine.verifyDetachedSignature(signedDocument, required, WS_ID_ATTRIBUTE, validatingKey, signatureNode);
    }

    private List<Element> getChildElements(Element from, String ns, String localName) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList children = from.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childE;
            Node child = children.item(i);
            if (!(child instanceof Element) || !localName.equals((childE = (Element)child).getLocalName()) || !ns.equals(childE.getNamespaceURI())) continue;
            ret.add(childE);
        }
        return ret;
    }

    private List<Element> getRequiredElements(Document signedDocument) {
        Vector<Object> shallBeSigned;
        if (this.partsDecider != null) {
            shallBeSigned = this.partsDecider.getElementsToBeSigned(signedDocument);
        } else {
            shallBeSigned = new Vector();
            shallBeSigned.add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", ""));
        }
        ArrayList<Element> ret = new ArrayList<Element>();
        for (WSEncryptionPart wSEncryptionPart : shallBeSigned) {
            logger.trace("Required part: " + wSEncryptionPart.getName());
            NodeList nl = signedDocument.getElementsByTagNameNS(wSEncryptionPart.getNamespace(), wSEncryptionPart.getName());
            if (nl.getLength() == 0) continue;
            for (int i = 0; i < nl.getLength(); ++i) {
                ret.add((Element)nl.item(i));
            }
        }
        return ret;
    }

    static {
        qnameSet.add(WS_SECURITY);
    }
}

