/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.wsutil.CXFUtils;
import eu.unicore.security.wsutil.DSigDecider;
import java.util.Set;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class ContextDSigDecider
implements DSigDecider {
    public static final String SIGN_MESSAGE = ContextDSigDecider.class.getName() + "doSign";
    public static final String SIGNED_OPERATIONS = ContextDSigDecider.class.getName() + "signedOperations";

    @Override
    public boolean isMessageDSigCandidate(Message message) {
        if (MessageUtils.isOutbound((Message)message)) {
            return this.clientCall(message);
        }
        return false;
    }

    private boolean clientCall(Message message) {
        if (Boolean.TRUE.equals(message.get((Object)SIGN_MESSAGE))) {
            return true;
        }
        Set signedOperations = (Set)message.get((Object)SIGNED_OPERATIONS);
        if (signedOperations == null) {
            return false;
        }
        String action = CXFUtils.getAction(message);
        if (action == null) {
            return false;
        }
        return signedOperations.contains(action);
    }
}

