/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class OnEmptyHandler
extends ProxyReceiver {
    private Expression onEmpty;
    private XPathContext context;
    private boolean savedDocumentNode;
    private NodeName savedNodeName;
    private SchemaType savedSchemaType;
    private int savedLocationId;
    private int savedProperties;
    private List<NamespaceBinding> savedNamespaces = new ArrayList<NamespaceBinding>(4);

    public OnEmptyHandler(Receiver next, Expression onEmpty, XPathContext context) {
        super(next);
        this.onEmpty = onEmpty;
        this.context = context;
    }

    private void flush() throws XPathException {
        if (this.savedNodeName != null) {
            this.nextReceiver.startElement(this.savedNodeName, this.savedSchemaType, this.savedLocationId, this.savedProperties);
            for (NamespaceBinding binding : this.savedNamespaces) {
                this.nextReceiver.namespace(binding, 0);
            }
            this.savedNodeName = null;
        } else if (this.savedDocumentNode) {
            this.nextReceiver.startDocument(this.savedProperties);
            this.savedDocumentNode = false;
        }
    }

    public void startDocument(int properties) throws XPathException {
        if ((properties & 0x20000) != 0) {
            this.savedDocumentNode = true;
            this.savedProperties = properties;
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if ((properties & 0x20000) != 0) {
            this.savedNodeName = elemName;
            this.savedSchemaType = typeCode;
            this.savedLocationId = locationId;
            this.savedProperties = properties & 0xFFFDFFFF;
        } else {
            this.flush();
            super.startElement(elemName, typeCode, locationId, properties);
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.savedNodeName != null) {
            this.savedNamespaces.add(namespaceBinding);
        } else {
            super.namespace(namespaceBinding, properties);
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.flush();
        super.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (chars.length() > 0) {
            this.flush();
            super.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.flush();
        super.processingInstruction(target, data, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.flush();
        super.comment(chars, locationId, properties);
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        this.flush();
        super.append(item, locationId, copyNamespaces);
    }

    public void endElement() throws XPathException {
        if (this.savedNodeName != null) {
            this.savedNodeName = null;
            Item onEmptyItem = this.onEmpty.evaluateItem(this.context);
            if (onEmptyItem instanceof NodeInfo) {
                ((NodeInfo)onEmptyItem).copy(this, 2, this.onEmpty.getLocationId());
            }
        } else {
            super.endElement();
        }
    }

    public void endDocument() throws XPathException {
        if (this.savedDocumentNode) {
            this.savedDocumentNode = false;
            Item onEmptyItem = this.onEmpty.evaluateItem(this.context);
            if (onEmptyItem instanceof NodeInfo) {
                ((NodeInfo)onEmptyItem).copy(this, 2, this.onEmpty.getLocationId());
            }
        }
    }
}

