/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.testing.FeederSpout;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import backtype.storm.utils.Utils;
import java.util.List;
import java.util.Map;
import storm.starter.bolt.SingleJoinBolt;

public class SingleJoinExample {
    public static void main(String[] args) {
        int i;
        FeederSpout genderSpout = new FeederSpout(new Fields(new String[]{"id", "gender"}));
        FeederSpout ageSpout = new FeederSpout(new Fields(new String[]{"id", "age"}));
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout("gender", (IRichSpout)genderSpout);
        builder.setSpout("age", (IRichSpout)ageSpout);
        ((BoltDeclarer)builder.setBolt("join", (IRichBolt)new SingleJoinBolt(new Fields(new String[]{"gender", "age"}))).fieldsGrouping("gender", new Fields(new String[]{"id"}))).fieldsGrouping("age", new Fields(new String[]{"id"}));
        Config conf = new Config();
        conf.setDebug(true);
        LocalCluster cluster = new LocalCluster();
        cluster.submitTopology("join-example", (Map)conf, builder.createTopology());
        for (i = 0; i < 10; ++i) {
            String gender = i % 2 == 0 ? "male" : "female";
            genderSpout.feed((List)new Values(new Object[]{i, gender}));
        }
        for (i = 9; i >= 0; --i) {
            ageSpout.feed((List)new Values(new Object[]{i, i + 20}));
        }
        Utils.sleep((long)2000L);
        cluster.shutdown();
    }
}

