/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.bolt;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.TimeCacheMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SingleJoinBolt
extends BaseRichBolt {
    OutputCollector _collector;
    Fields _idFields;
    Fields _outFields;
    int _numSources;
    TimeCacheMap<List<Object>, Map<GlobalStreamId, Tuple>> _pending;
    Map<String, GlobalStreamId> _fieldLocations;

    public SingleJoinBolt(Fields outFields) {
        this._outFields = outFields;
    }

    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this._fieldLocations = new HashMap<String, GlobalStreamId>();
        this._collector = collector;
        int timeout = ((Number)conf.get("topology.message.timeout.secs")).intValue();
        this._pending = new TimeCacheMap(timeout, (TimeCacheMap.ExpiredCallback)new ExpireCallback());
        this._numSources = context.getThisSources().size();
        HashSet idFields = null;
        for (GlobalStreamId source : context.getThisSources().keySet()) {
            Fields fields = context.getComponentOutputFields(source.get_componentId(), source.get_streamId());
            HashSet setFields = new HashSet(fields.toList());
            if (idFields == null) {
                idFields = setFields;
            } else {
                idFields.retainAll(setFields);
            }
            for (String outfield : this._outFields) {
                for (String sourcefield : fields) {
                    if (!outfield.equals(sourcefield)) continue;
                    this._fieldLocations.put(outfield, source);
                }
            }
        }
        this._idFields = new Fields(new ArrayList(idFields));
        if (this._fieldLocations.size() != this._outFields.size()) {
            throw new RuntimeException("Cannot find all outfields among sources");
        }
    }

    public void execute(Tuple tuple) {
        Map parts;
        List id = tuple.select(this._idFields);
        GlobalStreamId streamId = new GlobalStreamId(tuple.getSourceComponent(), tuple.getSourceStreamId());
        if (!this._pending.containsKey((Object)id)) {
            this._pending.put((Object)id, new HashMap());
        }
        if ((parts = (Map)this._pending.get((Object)id)).containsKey(streamId)) {
            throw new RuntimeException("Received same side of single join twice");
        }
        parts.put(streamId, tuple);
        if (parts.size() == this._numSources) {
            this._pending.remove((Object)id);
            ArrayList<Object> joinResult = new ArrayList<Object>();
            for (String outField : this._outFields) {
                GlobalStreamId loc = this._fieldLocations.get(outField);
                joinResult.add(((Tuple)parts.get(loc)).getValueByField(outField));
            }
            this._collector.emit(new ArrayList(parts.values()), joinResult);
            for (Tuple part : parts.values()) {
                this._collector.ack(part);
            }
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this._outFields);
    }

    private class ExpireCallback
    implements TimeCacheMap.ExpiredCallback<List<Object>, Map<GlobalStreamId, Tuple>> {
        private ExpireCallback() {
        }

        public void expire(List<Object> id, Map<GlobalStreamId, Tuple> tuples) {
            for (Tuple tuple : tuples.values()) {
                SingleJoinBolt.this._collector.fail(tuple);
            }
        }
    }
}

