/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.tools.DistCp;

public class Logalyzer {
    private static Configuration fsConfig = new Configuration();

    public void doArchive(String logListURI, String archiveDirectory) throws IOException {
        String destURL = FileSystem.getDefaultUri(fsConfig) + archiveDirectory;
        DistCp.copy(new JobConf(fsConfig), logListURI, destURL, null, true, false);
    }

    public void doAnalyze(String inputFilesDirectory, String outputDirectory, String grepPattern, String sortColumns, String columnSeparator) throws IOException {
        Path grepInput = new Path(inputFilesDirectory);
        Path analysisOutput = null;
        analysisOutput = outputDirectory.equals("") ? new Path(inputFilesDirectory, "logalyzer_" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE))) : new Path(outputDirectory);
        JobConf grepJob = new JobConf(fsConfig);
        grepJob.setJobName("logalyzer-grep-sort");
        FileInputFormat.setInputPaths(grepJob, grepInput);
        grepJob.setInputFormat(TextInputFormat.class);
        grepJob.setMapperClass(LogRegexMapper.class);
        grepJob.set("mapred.mapper.regex", grepPattern);
        grepJob.set("mapred.reducer.sort", sortColumns);
        grepJob.set("mapred.reducer.separator", columnSeparator);
        grepJob.setCombinerClass(LongSumReducer.class);
        grepJob.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath(grepJob, analysisOutput);
        grepJob.setOutputFormat(TextOutputFormat.class);
        grepJob.setOutputKeyClass(Text.class);
        grepJob.setOutputValueClass(LongWritable.class);
        grepJob.setOutputKeyComparatorClass(LogComparator.class);
        grepJob.setNumReduceTasks(1);
        JobClient.runJob(grepJob);
    }

    public static void main(String[] args) {
        Log LOG = LogFactory.getLog(Logalyzer.class);
        String version = "Logalyzer.0.0.1";
        String usage = "Usage: Logalyzer [-archive -logs <urlsFile>] -archiveDir <archiveDirectory> -grep <pattern> -sort <column1,column2,...> -separator <separator> -analysis <outputDirectory>";
        System.out.println(version);
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        boolean archive = false;
        boolean grep = false;
        boolean sort = false;
        String archiveDir = "";
        String logListURI = "";
        String grepPattern = ".*";
        String sortColumns = "";
        String columnSeparator = " ";
        String outputDirectory = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-archive")) {
                archive = true;
                continue;
            }
            if (args[i].equals("-archiveDir")) {
                archiveDir = args[++i];
                continue;
            }
            if (args[i].equals("-grep")) {
                grep = true;
                grepPattern = args[++i];
                continue;
            }
            if (args[i].equals("-logs")) {
                logListURI = args[++i];
                continue;
            }
            if (args[i].equals("-sort")) {
                sort = true;
                sortColumns = args[++i];
                continue;
            }
            if (args[i].equals("-separator")) {
                columnSeparator = args[++i];
                continue;
            }
            if (!args[i].equals("-analysis")) continue;
            outputDirectory = args[++i];
        }
        LOG.info("analysisDir = " + outputDirectory);
        LOG.info("archiveDir = " + archiveDir);
        LOG.info("logListURI = " + logListURI);
        LOG.info("grepPattern = " + grepPattern);
        LOG.info("sortColumns = " + sortColumns);
        LOG.info("separator = " + columnSeparator);
        try {
            Logalyzer logalyzer = new Logalyzer();
            if (archive) {
                logalyzer.doArchive(logListURI, archiveDir);
            }
            if (grep || sort) {
                logalyzer.doAnalyze(archiveDir, outputDirectory, grepPattern, sortColumns, columnSeparator);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    public static class LogComparator
    extends Text.Comparator
    implements Configurable {
        private static Log LOG = LogFactory.getLog(Logalyzer.class);
        private JobConf conf = null;
        private String[] sortSpec = null;
        private String columnSeparator = null;

        @Override
        public void setConf(Configuration conf) {
            this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
            String sortColumns = this.conf.get("mapred.reducer.sort", null);
            if (sortColumns != null) {
                this.sortSpec = sortColumns.split(",");
            }
            this.columnSeparator = this.conf.get("mapred.reducer.separator", "");
        }

        @Override
        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            if (this.sortSpec == null) {
                return super.compare(b1, s1, l1, b2, s2, l2);
            }
            try {
                Text logline1 = new Text();
                logline1.readFields(new DataInputStream(new ByteArrayInputStream(b1, s1, l1)));
                String line1 = logline1.toString();
                String[] logColumns1 = line1.split(this.columnSeparator);
                Text logline2 = new Text();
                logline2.readFields(new DataInputStream(new ByteArrayInputStream(b2, s2, l2)));
                String line2 = logline2.toString();
                String[] logColumns2 = line2.split(this.columnSeparator);
                if (logColumns1 == null || logColumns2 == null) {
                    return super.compare(b1, s1, l1, b2, s2, l2);
                }
                for (int i = 0; i < this.sortSpec.length; ++i) {
                    int column = Integer.valueOf(this.sortSpec[i]);
                    String c1 = logColumns1[column];
                    String c2 = logColumns2[column];
                    int comparision = Text.Comparator.compareBytes(c1.getBytes(), 0, c1.length(), c2.getBytes(), 0, c2.length());
                    if (comparision == 0) continue;
                    return comparision;
                }
            }
            catch (IOException ioe) {
                LOG.fatal("Caught " + ioe);
                return 0;
            }
            return 0;
        }

        static {
            WritableComparator.define(Text.class, new LogComparator());
        }
    }

    public static class LogRegexMapper<K extends WritableComparable>
    extends MapReduceBase
    implements Mapper<K, Text, Text, LongWritable> {
        private Pattern pattern;

        @Override
        public void configure(JobConf job) {
            this.pattern = Pattern.compile(job.get("mapred.mapper.regex"));
        }

        @Override
        public void map(K key, Text value, OutputCollector<Text, LongWritable> output, Reporter reporter) throws IOException {
            String text = value.toString();
            Matcher matcher = this.pattern.matcher(text);
            while (matcher.find()) {
                output.collect(value, new LongWritable(1L));
            }
        }
    }
}

