/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ResourceAllocationException;
import javax.security.auth.Subject;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.AutocommitSpecCompliant;
import org.tranql.connector.jdbc.KnownSQLStateExceptionSorter;
import org.tranql.connector.jdbc.ManagedJDBCConnection;
import org.tranql.connector.jdbc.TranqlDataSource;

public class JDBCDriverMCF
implements UserPasswordManagedConnectionFactory,
AutocommitSpecCompliant {
    private static final long serialVersionUID = 4317141492511322929L;
    private Driver driver;
    private String url;
    private String user;
    private String password;
    private ExceptionSorter exceptionSorter = new KnownSQLStateExceptionSorter();
    private boolean commitBeforeAutocommit = false;
    private PrintWriter log;

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("ConnectionManager is required");
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new TranqlDataSource(this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        Connection sqlConnection = this.getPhysicalConnection(subject, credentialExtractor);
        return new ManagedJDBCConnection(this, sqlConnection, credentialExtractor, this.exceptionSorter, this.commitBeforeAutocommit);
    }

    protected Connection getPhysicalConnection(Subject subject, CredentialExtractor credentialExtractor) throws ResourceException {
        String password;
        try {
            if (!this.driver.acceptsURL(this.url)) {
                throw new ResourceAdapterInternalException("JDBC Driver cannot handle url: " + this.url);
            }
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("JDBC Driver rejected url: " + this.url);
        }
        Properties info = new Properties();
        String user = credentialExtractor.getUserName();
        if (user != null) {
            info.setProperty("user", user);
        }
        if ((password = credentialExtractor.getPassword()) != null) {
            info.setProperty("password", password);
        }
        try {
            return this.driver.connect(this.url, info);
        }
        catch (SQLException e) {
            throw new ResourceAllocationException("Unable to obtain physical connection to " + this.url, (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        for (Object o : set) {
            ManagedConnectionHandle mc;
            if (!(o instanceof ManagedConnectionHandle) || !(mc = (ManagedConnectionHandle)o).matches(this, subject, connectionRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public void setLogWriter(PrintWriter log) {
        this.log = log;
    }

    public String getDriver() {
        return this.driver == null ? null : this.driver.getClass().getName();
    }

    public void setDriver(String driver) throws InvalidPropertyException {
        if (driver == null || driver.length() == 0) {
            throw new InvalidPropertyException("Empty driver class name");
        }
        try {
            Class<?> driverClass = this.loadClass(driver);
            this.driver = (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPropertyException("Unable to load driver class: " + driver, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InvalidPropertyException("Unable to instantiate driver class: " + driver, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidPropertyException("Unable to instantiate driver class: " + driver, (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new InvalidPropertyException("Class is not a " + Driver.class.getName() + ": " + driver, (Throwable)e);
        }
    }

    public String getConnectionURL() {
        return this.url;
    }

    public void setConnectionURL(String url) throws InvalidPropertyException {
        if (url == null || url.length() == 0) {
            throw new InvalidPropertyException("Empty connection URL");
        }
        this.url = url;
    }

    @Override
    public String getUserName() {
        return this.user;
    }

    public void setUserName(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Boolean isCommitBeforeAutocommit() {
        return this.commitBeforeAutocommit;
    }

    public void setCommitBeforeAutocommit(Boolean commitBeforeAutocommit) {
        this.commitBeforeAutocommit = commitBeforeAutocommit != null && commitBeforeAutocommit != false;
    }

    public String getExceptionSorterClass() {
        return this.exceptionSorter.getClass().getName();
    }

    public void setExceptionSorterClass(String className) throws InvalidPropertyException {
        if (className == null || className.length() == 0) {
            throw new InvalidPropertyException("Empty class name");
        }
        try {
            Class<?> clazz = this.loadClass(className);
            this.exceptionSorter = (ExceptionSorter)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPropertyException("Unable to load class: " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidPropertyException("Unable to instantiate class: " + className, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InvalidPropertyException("Unable to instantiate class: " + className, (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new InvalidPropertyException("Class is not a " + ExceptionSorter.class.getName() + ": " + this.driver, (Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JDBCDriverMCF) {
            JDBCDriverMCF other = (JDBCDriverMCF)obj;
            return this.url == other.url || this.url != null && this.url.equals(other.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url == null ? 0 : this.url.hashCode();
    }

    public String toString() {
        return "JDBCDriverMCF[" + this.user + "@" + this.url + "]";
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = this.getContextClassLoader();
        if (cl != null) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }
}

