/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.io.IWritable;

public final class TaskId
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ActivityId activityId;
    private int partition;

    public static TaskId create(DataInput dis) throws IOException {
        TaskId taskId = new TaskId();
        taskId.readFields(dis);
        return taskId;
    }

    private TaskId() {
    }

    public TaskId(ActivityId activityId, int partition) {
        this.activityId = activityId;
        this.partition = partition;
    }

    public ActivityId getActivityId() {
        return this.activityId;
    }

    public int getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TaskId)) {
            return false;
        }
        TaskId oTaskId = (TaskId)o;
        return oTaskId.partition == this.partition && oTaskId.activityId.equals(this.activityId);
    }

    public int hashCode() {
        return this.activityId.hashCode() + this.partition;
    }

    public String toString() {
        return "TID:" + this.activityId + ":" + this.partition;
    }

    public static TaskId parse(String str) {
        if (str.startsWith("TID:")) {
            str = str.substring(4);
            int idIdx = str.lastIndexOf(58);
            return new TaskId(ActivityId.parse(str.substring(0, idIdx)), Integer.parseInt(str.substring(idIdx + 1)));
        }
        throw new IllegalArgumentException("Unable to parse: " + str);
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        this.activityId.writeFields(output);
        output.writeInt(this.partition);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.activityId = ActivityId.create(input);
        this.partition = input.readInt();
    }
}

