/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.library.ExternalScalarFunctionEvaluator;
import org.apache.asterix.external.library.PythonLibraryEvaluator;
import org.apache.asterix.external.library.PythonLibraryEvaluatorFactory;
import org.apache.asterix.external.library.msgpack.MessageUnpackerToADM;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;

class ExternalScalarPythonFunctionEvaluator
extends ExternalScalarFunctionEvaluator {
    private final PythonLibraryEvaluator libraryEvaluator;
    private final ArrayBackedValueStorage resultBuffer = new ArrayBackedValueStorage();
    private final ByteBuffer argHolder;
    private final ByteBuffer outputWrapper;
    private final IEvaluatorContext evaluatorContext;
    private final IPointable[] argValues;
    private final SourceLocation sourceLocation;
    private MessageUnpacker unpacker;
    private ArrayBufferInput unpackerInput;
    private long fnId;

    ExternalScalarPythonFunctionEvaluator(IExternalFunctionInfo finfo, IScalarEvaluatorFactory[] args, IAType[] argTypes, IEvaluatorContext ctx, SourceLocation sourceLoc) throws HyracksDataException {
        super(finfo, args, argTypes, ctx);
        try {
            PythonLibraryEvaluatorFactory evaluatorFactory = new PythonLibraryEvaluatorFactory(ctx.getTaskContext());
            this.libraryEvaluator = evaluatorFactory.getEvaluator(finfo, sourceLoc);
            this.fnId = this.libraryEvaluator.initialize(finfo);
        }
        catch (IOException | AsterixException e) {
            throw new HyracksDataException("Failed to initialize Python", e);
        }
        this.argValues = new IPointable[args.length];
        for (int i = 0; i < this.argValues.length; ++i) {
            this.argValues[i] = VoidPointable.FACTORY.createPointable();
        }
        int maxArgSz = ExternalDataUtils.getArgBufferSize();
        this.argHolder = ByteBuffer.wrap(new byte[maxArgSz]);
        this.outputWrapper = ByteBuffer.wrap(new byte[maxArgSz]);
        this.evaluatorContext = ctx;
        this.sourceLocation = sourceLoc;
        this.unpackerInput = new ArrayBufferInput(new byte[0]);
        this.unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)this.unpackerInput);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.argHolder.clear();
        boolean nullCall = this.finfo.getNullCall();
        boolean hasNullArg = false;
        int ln = this.argEvals.length;
        for (int i = 0; i < ln; ++i) {
            this.argEvals[i].evaluate(tuple, this.argValues[i]);
            if (!nullCall) {
                int argStart;
                byte[] argBytes = this.argValues[i].getByteArray();
                ATypeTag argType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(argBytes[argStart = this.argValues[i].getStartOffset()]);
                if (argType == ATypeTag.MISSING) {
                    PointableHelper.setMissing((IPointable)result);
                    return;
                }
                if (argType == ATypeTag.NULL) {
                    hasNullArg = true;
                }
            }
            try {
                PythonLibraryEvaluator.setArgument(this.argTypes[i], (IValueReference)this.argValues[i], this.argHolder, nullCall);
                continue;
            }
            catch (IOException e) {
                throw new HyracksDataException("Error evaluating Python UDF", (Throwable)e);
            }
        }
        if (!nullCall && hasNullArg) {
            PointableHelper.setNull((IPointable)result);
            return;
        }
        try {
            ByteBuffer res = this.libraryEvaluator.callPython(this.fnId, this.argHolder, this.argTypes.length);
            this.resultBuffer.reset();
            this.wrap(res, this.resultBuffer.getDataOutput());
        }
        catch (Exception e) {
            throw new HyracksDataException("Error evaluating Python UDF", (Throwable)e);
        }
        result.set((IValueReference)this.resultBuffer);
    }

    private void wrap(ByteBuffer resultWrapper, DataOutput out) throws HyracksDataException {
        this.outputWrapper.clear();
        this.outputWrapper.position(0);
        try {
            if (resultWrapper == null) {
                this.outputWrapper.put(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                out.write(this.outputWrapper.array(), 0, this.outputWrapper.position() + this.outputWrapper.arrayOffset());
                return;
            }
            if ((resultWrapper.get() ^ 0xFFFFFF90) != 2) {
                throw HyracksDataException.create((Throwable)AsterixException.create((ErrorCode)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Returned result missing outer wrapper"}));
            }
            int numresults = resultWrapper.get() ^ 0xFFFFFF90;
            if (numresults > 0) {
                MessageUnpackerToADM.unpack(resultWrapper, this.outputWrapper, true);
            }
            this.unpackerInput.reset(resultWrapper.array(), resultWrapper.position() + resultWrapper.arrayOffset(), resultWrapper.remaining());
            this.unpacker.reset((MessageBufferInput)this.unpackerInput);
            int numEntries = this.unpacker.unpackArrayHeader();
            for (int j = 0; j < numEntries; ++j) {
                this.outputWrapper.put(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                if (!this.evaluatorContext.getWarningCollector().shouldWarn()) continue;
                this.evaluatorContext.getWarningCollector().warn(Warning.of((SourceLocation)this.sourceLocation, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{this.unpacker.unpackString()}));
            }
            out.write(this.outputWrapper.array(), 0, this.outputWrapper.position() + this.outputWrapper.arrayOffset());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

