/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.Arrays;
import org.apache.distributedlog.AppendOnlyStreamReader;
import org.apache.distributedlog.AppendOnlyStreamWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.exceptions.EndOfStreamException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAppendOnlyStreamReader
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestAppendOnlyStreamReader.class);
    @Rule
    public TestName testNames = new TestName();

    public void skipForwardThenSkipBack(String name, DistributedLogConfiguration conf) throws Exception {
        BKDistributedLogManager dlmwrite = this.createNewDLM(conf, name);
        BKDistributedLogManager dlmreader = this.createNewDLM(conf, name);
        long txid = 1L;
        AppendOnlyStreamWriter writer = dlmwrite.getAppendOnlyStreamWriter();
        writer.write(DLMTestUtil.repeatString("abc", 5).getBytes());
        writer.write(DLMTestUtil.repeatString("abc", 5).getBytes());
        writer.write(DLMTestUtil.repeatString("def", 5).getBytes());
        writer.write(DLMTestUtil.repeatString("def", 5).getBytes());
        writer.write(DLMTestUtil.repeatString("ghi", 5).getBytes());
        writer.write(DLMTestUtil.repeatString("ghi", 5).getBytes());
        writer.force(false);
        writer.close();
        AppendOnlyStreamReader reader = dlmreader.getAppendOnlyStreamReader();
        byte[] bytesIn = new byte[30];
        byte[] bytes1 = DLMTestUtil.repeatString("abc", 10).getBytes();
        byte[] bytes2 = DLMTestUtil.repeatString("def", 10).getBytes();
        byte[] bytes3 = DLMTestUtil.repeatString("ghi", 10).getBytes();
        int read = reader.read(bytesIn, 0, 30);
        Assert.assertEquals((long)30L, (long)read);
        Assert.assertTrue((boolean)Arrays.equals(bytes1, bytesIn));
        reader.skipTo(60L);
        read = reader.read(bytesIn, 0, 30);
        Assert.assertEquals((long)30L, (long)read);
        Assert.assertTrue((boolean)Arrays.equals(bytes3, bytesIn));
        reader.skipTo(30L);
        read = reader.read(bytesIn, 0, 30);
        Assert.assertEquals((long)30L, (long)read);
        Assert.assertTrue((boolean)Arrays.equals(bytes2, bytesIn));
    }

    @Test(timeout=60000L)
    public void testSkipToSkipsBytesWithImmediateFlush() throws Exception {
        String name = this.testNames.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setImmediateFlushEnabled(true);
        confLocal.setOutputBufferSize(0);
        this.skipForwardThenSkipBack(name, confLocal);
    }

    @Test(timeout=60000L)
    public void testSkipToSkipsBytesWithLargerLogRecords() throws Exception {
        String name = this.testNames.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setOutputBufferSize(102400);
        confLocal.setPeriodicFlushFrequencyMilliSeconds(60000);
        this.skipForwardThenSkipBack(name, confLocal);
    }

    @Test(timeout=60000L)
    public void testSkipToSkipsBytesUntilEndOfStream() throws Exception {
        String name = this.testNames.getMethodName();
        BKDistributedLogManager dlmwrite = this.createNewDLM(conf, name);
        BKDistributedLogManager dlmreader = this.createNewDLM(conf, name);
        long txid = 1L;
        AppendOnlyStreamWriter writer = dlmwrite.getAppendOnlyStreamWriter();
        writer.write(DLMTestUtil.repeatString("abc", 5).getBytes());
        writer.markEndOfStream();
        writer.force(false);
        writer.close();
        AppendOnlyStreamReader reader = dlmreader.getAppendOnlyStreamReader();
        byte[] bytesIn = new byte[9];
        int read = reader.read(bytesIn, 0, 9);
        Assert.assertEquals((long)9L, (long)read);
        Assert.assertTrue((boolean)Arrays.equals(DLMTestUtil.repeatString("abc", 3).getBytes(), bytesIn));
        Assert.assertTrue((boolean)reader.skipTo(15L));
        try {
            read = reader.read(bytesIn, 0, 1);
            Assert.fail((String)"Should have thrown");
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)reader.skipTo(0L));
        try {
            reader.skipTo(16L);
            Assert.fail((String)"Should have thrown");
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testSkipToreturnsFalseIfPositionDoesNotExistYetForUnSealedStream() throws Exception {
        String name = this.testNames.getMethodName();
        BKDistributedLogManager dlmwrite = this.createNewDLM(conf, name);
        BKDistributedLogManager dlmreader = this.createNewDLM(conf, name);
        long txid = 1L;
        AppendOnlyStreamWriter writer = dlmwrite.getAppendOnlyStreamWriter();
        writer.write(DLMTestUtil.repeatString("abc", 5).getBytes());
        writer.close();
        AppendOnlyStreamReader reader = dlmreader.getAppendOnlyStreamReader();
        byte[] bytesIn = new byte[9];
        int read = reader.read(bytesIn, 0, 9);
        Assert.assertEquals((long)9L, (long)read);
        Assert.assertTrue((boolean)Arrays.equals(DLMTestUtil.repeatString("abc", 3).getBytes(), bytesIn));
        Assert.assertFalse((boolean)reader.skipTo(16L));
        Assert.assertFalse((boolean)reader.skipTo(16L));
        AppendOnlyStreamWriter writer2 = dlmwrite.getAppendOnlyStreamWriter();
        writer2.write(DLMTestUtil.repeatString("abc", 5).getBytes());
        writer2.close();
        Assert.assertTrue((boolean)reader.skipTo(16L));
        byte[] bytesIn2 = new byte[5];
        read = reader.read(bytesIn2, 0, 5);
        Assert.assertEquals((long)5L, (long)read);
        Assert.assertTrue((boolean)Arrays.equals("bcabc".getBytes(), bytesIn2));
    }

    @Test(timeout=60000L)
    public void testSkipToForNoPositionChange() throws Exception {
        String name = this.testNames.getMethodName();
        BKDistributedLogManager dlmwrite = this.createNewDLM(conf, name);
        BKDistributedLogManager dlmreader = this.createNewDLM(conf, name);
        long txid = 1L;
        AppendOnlyStreamWriter writer = dlmwrite.getAppendOnlyStreamWriter();
        writer.write(DLMTestUtil.repeatString("abc", 5).getBytes());
        writer.close();
        AppendOnlyStreamReader reader = dlmreader.getAppendOnlyStreamReader();
        Assert.assertTrue((boolean)reader.skipTo(0L));
        byte[] bytesIn = new byte[4];
        int read = reader.read(bytesIn, 0, 4);
        Assert.assertEquals((long)4L, (long)read);
        Assert.assertEquals((Object)new String("abca"), (Object)new String(bytesIn));
        Assert.assertTrue((boolean)reader.skipTo(reader.position()));
        Assert.assertTrue((boolean)reader.skipTo(1L));
        read = reader.read(bytesIn, 0, 4);
        Assert.assertEquals((long)4L, (long)read);
        Assert.assertEquals((Object)new String("bcab"), (Object)new String(bytesIn));
    }
}

