/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.AtomicFileWritingIdiom;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AtomicFileWritingIdiomTest
extends ZKTestCase {
    private static File tmpdir;

    @BeforeClass
    public static void createTmpDir() {
        tmpdir = new File("build/test/tmp");
        tmpdir.mkdirs();
    }

    @Test
    public void testOutputStreamSuccess() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

            public void write(OutputStream os) throws IOException {
                os.write("after".getBytes(StandardCharsets.US_ASCII));
                Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
            }
        });
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertEquals((Object)"after", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testWriterSuccess() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

            public void write(Writer os) throws IOException {
                os.write("after");
                Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
            }
        });
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertEquals((Object)"after", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testOutputStreamFailure() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testWriterFailure() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testOutputStreamFailureIOException() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new IOException();
                }
            });
        }
        catch (IOException ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testWriterFailureIOException() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new IOException();
                }
            });
        }
        catch (IOException ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testOutputStreamFailureError() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new Error();
                }
            });
        }
        catch (Error ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testWriterFailureError() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new Error();
                }
            });
        }
        catch (Error ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertEquals((Object)"before", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testOutputStreamSuccessNE() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assert.assertFalse((String)"file should not exist", (boolean)target.exists());
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

            public void write(OutputStream os) throws IOException {
                os.write("after".getBytes(StandardCharsets.US_ASCII));
                Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
            }
        });
        Assert.assertEquals((Object)"after", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testWriterSuccessNE() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assert.assertFalse((String)"file should not exist", (boolean)target.exists());
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

            public void write(Writer os) throws IOException {
                os.write("after");
                Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
            }
        });
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertEquals((Object)"after", (Object)this.getContent(target));
        target.delete();
    }

    @Test
    public void testOutputStreamFailureNE() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assert.assertFalse((String)"file should not exist", (boolean)target.exists());
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertFalse((String)"file should not exist", (boolean)target.exists());
    }

    @Test
    public void testWriterFailureNE() throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assert.assertFalse((String)"file should not exist", (boolean)target.exists());
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assert.assertTrue((String)"implementation of AtomicFileOutputStream has changed, update the test", (boolean)tmp.exists());
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assert.assertFalse((String)"tmp file should have been deleted", (boolean)tmp.exists());
        Assert.assertTrue((String)"should have raised an exception", (boolean)exception);
        Assert.assertFalse((String)"file should not exist", (boolean)target.exists());
    }

    private String getContent(File file, String encoding) throws IOException {
        int nb;
        StringBuilder result = new StringBuilder();
        FileInputStream fis = new FileInputStream(file);
        byte[] b = new byte[20];
        while ((nb = fis.read(b)) != -1) {
            result.append(new String(b, 0, nb, encoding));
        }
        fis.close();
        return result.toString();
    }

    private String getContent(File file) throws IOException {
        return this.getContent(file, "ASCII");
    }

    private void createFile(File file, String content) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content.getBytes(StandardCharsets.US_ASCII));
        fos.close();
    }
}

