/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.IOException;
import java.security.KeyStore;
import java.util.Collection;
import org.apache.zookeeper.common.BaseX509ParameterizedTestCase;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.PKCS12FileLoader;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.common.X509TestContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PKCS12FileLoaderTest
extends BaseX509ParameterizedTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return BaseX509ParameterizedTestCase.defaultParams();
    }

    public PKCS12FileLoaderTest(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) {
        super(paramIndex, () -> {
            try {
                return X509TestContext.newBuilder().setTempDir(tempDir).setKeyStorePassword(keyPassword).setKeyStoreKeyType(certKeyType).setTrustStorePassword(keyPassword).setTrustStoreKeyType(caKeyType).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLoadKeyStore() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        KeyStore ks = ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
        Assert.assertEquals((long)1L, (long)ks.size());
    }

    @Test(expected=Exception.class)
    public void testLoadKeyStoreWithWrongPassword() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path).setKeyStorePassword("wrong password").build()).loadKeyStore();
    }

    @Test(expected=IOException.class)
    public void testLoadKeyStoreWithWrongFilePath() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path + ".does_not_exist").setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test(expected=NullPointerException.class)
    public void testLoadKeyStoreWithNullFilePath() throws Exception {
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test(expected=IOException.class)
    public void testLoadKeyStoreWithWrongFileType() throws Exception {
        String path = this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setKeyStorePath(path).setKeyStorePassword(this.x509TestContext.getKeyStorePassword()).build()).loadKeyStore();
    }

    @Test
    public void testLoadTrustStore() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        KeyStore ts = ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
        Assert.assertEquals((long)1L, (long)ts.size());
    }

    @Test(expected=Exception.class)
    public void testLoadTrustStoreWithWrongPassword() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path).setTrustStorePassword("wrong password").build()).loadTrustStore();
    }

    @Test(expected=IOException.class)
    public void testLoadTrustStoreWithWrongFilePath() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath();
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path + ".does_not_exist").setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }

    @Test(expected=NullPointerException.class)
    public void testLoadTrustStoreWithNullFilePath() throws Exception {
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }

    @Test(expected=IOException.class)
    public void testLoadTrustStoreWithWrongFileType() throws Exception {
        String path = this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath();
        ((PKCS12FileLoader)new PKCS12FileLoader.Builder().setTrustStorePath(path).setTrustStorePassword(this.x509TestContext.getTrustStorePassword()).build()).loadTrustStore();
    }
}

